/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Scored;
import java.util.Comparator;

public final class ScoredComparator
implements Comparator {
    public static final boolean ASCENDING = true;
    public static final boolean DESCENDING = false;
    public static final ScoredComparator ASCENDING_COMPARATOR = new ScoredComparator(true);
    public static final ScoredComparator DESCENDING_COMPARATOR = new ScoredComparator(false);
    private final boolean ascending;

    public ScoredComparator() {
        this.ascending = true;
    }

    public ScoredComparator(boolean ascending) {
        this.ascending = ascending;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        double d1 = ((Scored)o1).score();
        double d2 = ((Scored)o2).score();
        if (this.ascending) {
            if (d1 < d2) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
        } else {
            if (d1 < d2) {
                return 1;
            }
            if (d1 > d2) {
                return -1;
            }
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ScoredComparator) {
            ScoredComparator sc = (ScoredComparator)o;
            if (this.ascending == sc.ascending) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.ascending) {
            return 0x800000;
        }
        return 0x800001;
    }
}

