/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtils {
    protected ArrayUtils() {
    }

    public static double[] flatten(double[][] array) {
        int size = 0;
        for (double[] a : array) {
            size += a.length;
        }
        double[] newArray = new double[size];
        int i = 0;
        double[][] arr$ = array;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double[] a;
            for (double d : a = arr$[i$]) {
                newArray[i++] = d;
            }
        }
        return newArray;
    }

    public static double[][] to2D(double[] array, int dim1Size) {
        int dim2Size = array.length / dim1Size;
        return ArrayUtils.to2D(array, dim1Size, dim2Size);
    }

    public static double[][] to2D(double[] array, int dim1Size, int dim2Size) {
        double[][] newArray = new double[dim1Size][dim2Size];
        int k = 0;
        for (int i = 0; i < newArray.length; ++i) {
            for (int j = 0; j < newArray[i].length; ++j) {
                newArray[i][j] = array[k++];
            }
        }
        return newArray;
    }

    public static double[] removeAt(double[] array, int index) {
        if (array == null) {
            return null;
        }
        if (index < 0 || index >= array.length) {
            return array;
        }
        double[] retVal = new double[array.length - 1];
        for (int i = 0; i < array.length; ++i) {
            if (i < index) {
                retVal[i] = array[i];
                continue;
            }
            if (i <= index) continue;
            retVal[i - 1] = array[i];
        }
        return retVal;
    }

    public static Object[] removeAt(Object[] array, int index) {
        if (array == null) {
            return null;
        }
        if (index < 0 || index >= array.length) {
            return array;
        }
        Object[] retVal = (Object[])Array.newInstance(array[0].getClass(), array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i < index) {
                retVal[i] = array[i];
                continue;
            }
            if (i <= index) continue;
            retVal[i - 1] = array[i];
        }
        return retVal;
    }

    public static String toString(int[][] a) {
        String result = "[";
        for (int i = 0; i < a.length; ++i) {
            result = result + Arrays.toString(a[i]);
            if (i >= a.length - 1) continue;
            result = result + ",";
        }
        result = result + "]";
        return result;
    }

    public static boolean equalContents(int[][] xs, int[][] ys) {
        if (xs == null && ys != null) {
            return false;
        }
        if (ys == null) {
            return false;
        }
        if (xs.length != ys.length) {
            return false;
        }
        for (int i = xs.length - 1; i >= 0; --i) {
            if (ArrayUtils.equalContents(xs[i], ys[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalContents(int[] xs, int[] ys) {
        if (xs.length != ys.length) {
            return false;
        }
        for (int i = xs.length - 1; i >= 0; --i) {
            if (xs[i] == ys[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(boolean[][] xs, boolean[][] ys) {
        if (xs == null && ys != null) {
            return false;
        }
        if (ys == null) {
            return false;
        }
        if (xs.length != ys.length) {
            return false;
        }
        for (int i = xs.length - 1; i >= 0; --i) {
            if (Arrays.equals(xs[i], ys[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean contains(T[] a, T o) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    public static <T> Set<T> asSet(T[] a) {
        return new HashSet<T>(Arrays.asList(a));
    }

    public static void fill(double[][] d, double val) {
        for (int i = 0; i < d.length; ++i) {
            Arrays.fill(d[i], val);
        }
    }

    public static void fill(double[][][] d, double val) {
        for (int i = 0; i < d.length; ++i) {
            ArrayUtils.fill(d[i], val);
        }
    }

    public static void fill(double[][][][] d, double val) {
        for (int i = 0; i < d.length; ++i) {
            ArrayUtils.fill(d[i], val);
        }
    }

    public static void fill(boolean[][] d, boolean val) {
        for (int i = 0; i < d.length; ++i) {
            Arrays.fill(d[i], val);
        }
    }

    public static void fill(boolean[][][] d, boolean val) {
        for (int i = 0; i < d.length; ++i) {
            ArrayUtils.fill(d[i], val);
        }
    }

    public static void fill(boolean[][][][] d, boolean val) {
        for (int i = 0; i < d.length; ++i) {
            ArrayUtils.fill(d[i], val);
        }
    }

    public static List<Integer> asList(int[] array) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i : array) {
            l.add(i);
        }
        return l;
    }

    public static void main(String[] args) {
        Object[] strings = new String[]{"a", "b", "c"};
        strings = (String[])ArrayUtils.removeAt(strings, 2);
        for (int i = 0; i < strings.length; ++i) {
            System.err.println((String)strings[i]);
        }
        System.err.println(ArrayUtils.asSet(new String[]{"larry", "moe", "curly"}));
    }

    public static int[] copy(int[] i) {
        int[] newI = new int[i.length];
        System.arraycopy(i, 0, newI, 0, i.length);
        return newI;
    }

    public static double[] copy(double[] d) {
        if (d == null) {
            return null;
        }
        double[] newD = new double[d.length];
        System.arraycopy(d, 0, newD, 0, d.length);
        return newD;
    }

    public static double[][] copy(double[][] d) {
        if (d == null) {
            return null;
        }
        double[][] newD = new double[d.length][];
        for (int i = 0; i < newD.length; ++i) {
            newD[i] = ArrayUtils.copy(d[i]);
        }
        return newD;
    }

    public static double[][][] copy(double[][][] d) {
        if (d == null) {
            return null;
        }
        double[][][] newD = new double[d.length][][];
        for (int i = 0; i < newD.length; ++i) {
            newD[i] = ArrayUtils.copy(d[i]);
        }
        return newD;
    }

    public static float[] copy(float[] d) {
        if (d == null) {
            return null;
        }
        float[] newD = new float[d.length];
        System.arraycopy(d, 0, newD, 0, d.length);
        return newD;
    }

    public static float[][] copy(float[][] d) {
        if (d == null) {
            return null;
        }
        float[][] newD = new float[d.length][];
        for (int i = 0; i < newD.length; ++i) {
            newD[i] = ArrayUtils.copy(d[i]);
        }
        return newD;
    }

    public static float[][][] copy(float[][][] d) {
        if (d == null) {
            return null;
        }
        float[][][] newD = new float[d.length][][];
        for (int i = 0; i < newD.length; ++i) {
            newD[i] = ArrayUtils.copy(d[i]);
        }
        return newD;
    }

    public static String toString(boolean[][] b) {
        String result = "[";
        for (int i = 0; i < b.length; ++i) {
            result = result + Arrays.toString(b[i]);
            if (i >= b.length - 1) continue;
            result = result + ",";
        }
        result = result + "]";
        return result;
    }
}

