/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CoindexationGenerator {
    private static Pattern coindexationPattern = Pattern.compile("-([0-9]+)$");
    private int lastIndex;

    CoindexationGenerator() {
    }

    public void setLastIndex(Tree t) {
        this.lastIndex = 0;
        for (Tree node : t.subTreeList()) {
            Matcher m = coindexationPattern.matcher(node.label().value());
            if (!m.find()) continue;
            int thisIndex = Integer.parseInt(m.group(1));
            this.lastIndex = Math.max(thisIndex, this.lastIndex);
        }
    }

    public int generateIndex() {
        ++this.lastIndex;
        return this.lastIndex;
    }
}

