/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.VariableStrings;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CoordinationPattern
extends TregexPattern {
    private boolean isConj;
    private List children;

    public CoordinationPattern(List children, boolean isConj) {
        if (children.size() < 2) {
            throw new RuntimeException("Coordination node must have at least 2 children.");
        }
        this.children = children;
        this.isConj = isConj;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public String localString() {
        return this.isConj ? "and" : "or";
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isConj) {
            for (TregexPattern node : this.children) {
                sb.append(node.toString());
            }
        } else {
            sb.append('[');
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                TregexPattern node = (TregexPattern)iter.next();
                sb.append(node.toString());
                if (!iter.hasNext()) continue;
                sb.append(" |");
            }
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public TregexMatcher matcher(Tree root, Tree tree, Map<Object, Tree> namesToNodes, VariableStrings variableStrings) {
        return new CoordinationMatcher(this, root, tree, namesToNodes, variableStrings);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CoordinationMatcher
    extends TregexMatcher {
        private TregexMatcher[] children;
        private final CoordinationPattern myNode;
        private int currChild;
        private final boolean considerAll;

        public CoordinationMatcher(CoordinationPattern n, Tree root, Tree tree, Map<Object, Tree> namesToNodes, VariableStrings variableStrings) {
            super(root, tree, namesToNodes, variableStrings);
            this.myNode = n;
            this.children = new TregexMatcher[this.myNode.children.size()];
            for (int i = 0; i < this.children.length; ++i) {
                TregexPattern node = (TregexPattern)this.myNode.children.get(i);
                this.children[i] = node.matcher(root, tree, namesToNodes, variableStrings);
            }
            this.currChild = 0;
            this.considerAll = this.myNode.isConj ^ this.myNode.isNegated();
        }

        @Override
        void resetChildIter() {
            this.currChild = 0;
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].resetChildIter();
            }
        }

        @Override
        void resetChildIter(Tree tree) {
            this.tree = tree;
            this.currChild = 0;
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].resetChildIter(tree);
            }
        }

        @Override
        public boolean matches() {
            if (this.considerAll) {
                while (this.currChild >= 0 && this.myNode.isNegated() == this.children[this.currChild].matches()) {
                    this.children[this.currChild].resetChildIter();
                    --this.currChild;
                }
                if (this.currChild < 0) {
                    return this.myNode.isOptional();
                }
                while (this.currChild + 1 < this.children.length) {
                    ++this.currChild;
                    if (this.myNode.isNegated() != this.children[this.currChild].matches()) continue;
                    this.currChild = -1;
                    return this.myNode.isOptional();
                }
                if (this.myNode.isNegated()) {
                    this.currChild = -1;
                }
                return true;
            }
            while (this.currChild < this.children.length) {
                if (this.myNode.isNegated() != this.children[this.currChild].matches()) {
                    if (this.myNode.isNegated()) {
                        this.currChild = this.children.length;
                    }
                    return true;
                }
                ++this.currChild;
            }
            if (this.myNode.isNegated()) {
                this.currChild = this.children.length;
            }
            return this.myNode.isOptional();
        }

        @Override
        public Tree getMatch() {
            throw new UnsupportedOperationException();
        }
    }
}

