/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.trees.AbstractTreebankLanguagePack;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Filters;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChineseTreebankLanguagePack
extends AbstractTreebankLanguagePack
implements Serializable {
    private static TokenizerFactory tf;
    public static final String ENCODING = "GB18030";
    private static final char[] annotationIntroducingChars;
    private static final String[] startSymbols;
    private static final String[] tags;
    private static final String[] comma;
    private static final String[] endSentence;
    private static final String[] douHao;
    private static final String[] quoteMark;
    private static final String[] parenthesis;
    private static final String[] colon;
    private static final String[] dash;
    private static final String[] other;
    private static String[] leftQuoteMark;
    private static String[] rightQuoteMark;
    private static String[] leftParenthesis;
    private static String[] rightParenthesis;
    private static final String[] punctWords;
    private static final long serialVersionUID = 5757403475523638802L;

    public static void setTokenizerFactory(TokenizerFactory tf) {
        ChineseTreebankLanguagePack.tf = tf;
    }

    @Override
    public TokenizerFactory getTokenizerFactory() {
        if (tf != null) {
            return tf;
        }
        return super.getTokenizerFactory();
    }

    @Override
    public String getEncoding() {
        return ENCODING;
    }

    @Override
    public boolean isPunctuationTag(String str) {
        return str.equals("PU");
    }

    @Override
    public boolean isPunctuationWord(String str) {
        return ChineseTreebankLanguagePack.chineseCommaAcceptFilter().accept(str) || ChineseTreebankLanguagePack.chineseEndSentenceAcceptFilter().accept(str) || ChineseTreebankLanguagePack.chineseDouHaoAcceptFilter().accept(str) || ChineseTreebankLanguagePack.chineseQuoteMarkAcceptFilter().accept(str) || ChineseTreebankLanguagePack.chineseParenthesisAcceptFilter().accept(str) || ChineseTreebankLanguagePack.chineseColonAcceptFilter().accept(str) || ChineseTreebankLanguagePack.chineseDashAcceptFilter().accept(str) || ChineseTreebankLanguagePack.chineseOtherAcceptFilter().accept(str);
    }

    @Override
    public boolean isSentenceFinalPunctuationTag(String str) {
        return ChineseTreebankLanguagePack.chineseEndSentenceAcceptFilter().accept(str);
    }

    @Override
    public String[] punctuationTags() {
        return tags;
    }

    @Override
    public String[] punctuationWords() {
        return punctWords;
    }

    @Override
    public String[] sentenceFinalPunctuationTags() {
        return tags;
    }

    @Override
    public String[] sentenceFinalPunctuationWords() {
        return endSentence;
    }

    @Override
    public boolean isEvalBIgnoredPunctuationTag(String str) {
        return Filters.collectionAcceptFilter(tags).accept(str);
    }

    @Override
    public char[] labelAnnotationIntroducingCharacters() {
        return annotationIntroducingChars;
    }

    @Override
    public String[] startSymbols() {
        return startSymbols;
    }

    public static Filter<String> chineseCommaAcceptFilter() {
        return Filters.collectionAcceptFilter(comma);
    }

    public static Filter<String> chineseEndSentenceAcceptFilter() {
        return Filters.collectionAcceptFilter(endSentence);
    }

    public static Filter<String> chineseDouHaoAcceptFilter() {
        return Filters.collectionAcceptFilter(douHao);
    }

    public static Filter<String> chineseQuoteMarkAcceptFilter() {
        return Filters.collectionAcceptFilter(quoteMark);
    }

    public static Filter<String> chineseParenthesisAcceptFilter() {
        return Filters.collectionAcceptFilter(parenthesis);
    }

    public static Filter<String> chineseColonAcceptFilter() {
        return Filters.collectionAcceptFilter(colon);
    }

    public static Filter<String> chineseDashAcceptFilter() {
        return Filters.collectionAcceptFilter(dash);
    }

    public static Filter<String> chineseOtherAcceptFilter() {
        return Filters.collectionAcceptFilter(other);
    }

    public static Filter<String> chineseLeftParenthesisAcceptFilter() {
        return Filters.collectionAcceptFilter(leftParenthesis);
    }

    public static Filter<String> chineseRightParenthesisAcceptFilter() {
        return Filters.collectionAcceptFilter(rightParenthesis);
    }

    public static Filter<String> chineseLeftQuoteMarkAcceptFilter() {
        return Filters.collectionAcceptFilter(leftQuoteMark);
    }

    public static Filter<String> chineseRightQuoteMarkAcceptFilter() {
        return Filters.collectionAcceptFilter(rightQuoteMark);
    }

    @Override
    public String treebankFileExtension() {
        return "fid";
    }

    @Override
    public GrammaticalStructureFactory grammaticalStructureFactory() {
        return new GrammaticalStructureFactory("edu.stanford.nlp.trees.international.pennchinese.ChineseGrammaticalStructure");
    }

    @Override
    public GrammaticalStructureFactory grammaticalStructureFactory(Filter<String> puncFilt) {
        return new GrammaticalStructureFactory("edu.stanford.nlp.trees.international.pennchinese.ChineseGrammaticalStructure", puncFilt);
    }

    static {
        annotationIntroducingChars = new char[]{'-', '=', '|', '#', '^', '~'};
        startSymbols = new String[]{"ROOT"};
        tags = new String[]{"PU"};
        comma = new String[]{",", "\uff0c", "\u3000"};
        endSentence = new String[]{"\u3002", "\uff0e", "\uff01", "\uff1f", "?", "!", "."};
        douHao = new String[]{"\u3001"};
        quoteMark = new String[]{"\u201c", "\u201d", "\u2018", "\u2019", "\u300a", "\u300b", "\u300e", "\u300f", "\u3008", "\u3009", "\u300c", "\u300d", "\uff02", "\uff1c", "\uff1e", "`", "\uff07"};
        parenthesis = new String[]{"\uff08", "\uff09", "-LRB-", "-RRB-"};
        colon = new String[]{"\uff1a", "\uff1b", "\u2236", ":"};
        dash = new String[]{"\u2026", "\u2014", "\u2014\u2014", "\u2014\u2014\u2014", "\uff0d", "\uff0d\uff0d", "\u2500\u2500", "\u2501", "\u2501\u2501", "\u2014\uff0d", "-", "----", "~", "\u2026\u2026"};
        other = new String[]{"\u00b7", "\uff0f", "\uff0f", "\uff0a", "\uff06", "/", "//"};
        leftQuoteMark = new String[]{"\u201c", "\u2018", "\u300a", "\u300e", "\u3008", "\u300c", "\uff1c", "`"};
        rightQuoteMark = new String[]{"\u201d", "\u2019", "\u300b", "\u300f", "\u3009", "\u300d", "\uff1e", "\uff07"};
        leftParenthesis = new String[]{"\uff08", "-LRB-"};
        rightParenthesis = new String[]{"\uff09", "-RRB-"};
        int n = tags.length + comma.length + endSentence.length + douHao.length + quoteMark.length + parenthesis.length + colon.length + dash.length + other.length;
        punctWords = new String[n];
        int m = 0;
        System.arraycopy(tags, 0, punctWords, m, tags.length);
        System.arraycopy(comma, 0, punctWords, m += tags.length, comma.length);
        System.arraycopy(endSentence, 0, punctWords, m += comma.length, endSentence.length);
        System.arraycopy(douHao, 0, punctWords, m += endSentence.length, douHao.length);
        System.arraycopy(quoteMark, 0, punctWords, m += douHao.length, quoteMark.length);
        System.arraycopy(parenthesis, 0, punctWords, m += quoteMark.length, parenthesis.length);
        System.arraycopy(colon, 0, punctWords, m += parenthesis.length, colon.length);
        System.arraycopy(dash, 0, punctWords, m += colon.length, dash.length);
        System.arraycopy(other, 0, punctWords, m += dash.length, other.length);
    }
}

