/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.arabic;

import edu.stanford.nlp.trees.PennTreebankTokenizer;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class ArabicTreebankTokenizer
extends PennTreebankTokenizer {
    public ArabicTreebankTokenizer(Reader r) {
        super(r);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getNext() {
        try {
            int nextToken;
            block8: while (true) {
                nextToken = this.st.nextToken();
                switch (nextToken) {
                    case 10: {
                        return this.eolString;
                    }
                    case -1: {
                        return null;
                    }
                    case -3: {
                        if (!this.st.sval.equals(":::")) {
                            return this.st.sval;
                        }
                        nextToken = this.st.nextToken();
                        nextToken = this.st.nextToken();
                        if (this.st.sval.equals(":::")) continue block8;
                        System.err.println("ArabicTreebankTokenizer assumptions broken!");
                        continue block8;
                    }
                    case -2: {
                        return Double.toString(this.st.nval);
                    }
                }
                break;
            }
            char[] t = new char[]{(char)nextToken};
            return new String(t);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        ArabicTreebankTokenizer att = new ArabicTreebankTokenizer(new FileReader(args[0]));
        while (att.hasNext()) {
            System.out.println(att.next());
        }
    }
}

