/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnglishGrammaticalRelations {
    public static final GrammaticalRelation PREDICATE = new GrammaticalRelation("pred", "predicate", GrammaticalRelation.DEPENDENT, "S|SINV", new String[]{"S < VP=target"});
    public static final GrammaticalRelation AUX_MODIFIER = new GrammaticalRelation("aux", "auxiliary", GrammaticalRelation.DEPENDENT, "VP|SQ", new String[]{"VP < VP < /^(?:TO|MD|VB.*)$/=target", "SQ < (/^VB|MD/=target $++ /^(?:VP|ADJP)/)"});
    public static final GrammaticalRelation AUX_PASSIVE_MODIFIER = new GrammaticalRelation("auxpass", "passive auxiliary", AUX_MODIFIER, "VP|SQ", new String[]{"VP < (/^(?:VB|AUXG?)/=target < /be|was|'s|is|are|were|been|being|am|Been|Being|WAS|IS|get|got|getting|gets|Get|gotten|becomes|become|became|felt|feels|feel|seems|seem|seemed|remains|remained|remain/) < (VP|ADJP < VBN|VBD)", "VP < (/^(?:VB|AUXG?)/=target < /be|was|'s|is|are|were|been|being|am|Been|Being|WAS|IS|get|got|getting|gets|Get|gotten|becomes|become|became|felt|feels|feel|seems|seem|seemed|remains|remained|remain/) < (VP|ADJP < (VP|ADJP < VBN|VBD) < CC)", "SQ < (/^(?:VB|AUX)/=target < /^(?:was|is|are|were|am|Was|Is|Are|Were|Am|WAS|IS|ARE|WERE|AM)$/ $++ (VP < /^VB[DN]$/))"});
    public static final GrammaticalRelation COPULA = new GrammaticalRelation("cop", "copula", AUX_MODIFIER, "VP|SQ", new String[]{"VP < (/^VB/=target < /(?i)^(?:am|'m|are|'re|is|'s|was|were|seem|seems|seemed|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|become|becomes|became)$/ $++ (ADJP|NP !< VBN))", "SQ <, (/^VB/=target < /(?i)^(am|are|is|was|were)$/) !$ /^WH*/"});
    public static final GrammaticalRelation CONJUNCT = new GrammaticalRelation("conj", "conjunct", GrammaticalRelation.DEPENDENT, "VP|NP|ADJP|PP|ADVP|UCP|S|NX|SBAR", new String[]{"VP|ADJP|PP|NP|ADVP|UCP|S|NX|SBAR < (CC|CONJP $+ !PRN=target) !<, CC", "VP|ADJP|PP|NP|ADVP|UCP|S|SBAR < (CC|CONJP $+ (ADVP $+ !PRN=target))", "VP|ADJP|PP|NP|ADVP|UCP|S|NX|SBAR < CC|CONJP < (/^,$/ $+ /^(A|N|V|PP|PRP|J|W|R|S)/=target)", "VP|ADJP|PP|NP|ADVP|UCP|S|NX|SBAR < CC|CONJP < (PRN $+ /^(A|N|V|PP|PRP|J|W|R|S)/=target)"});
    public static final GrammaticalRelation COORDINATION = new GrammaticalRelation("cc", "coordination", GrammaticalRelation.DEPENDENT, "S|VP|NP|ADJP|PP|ADVP|UCP|NX|SBAR", new String[]{"S|VP|NP|ADJP|PP|ADVP|UCP|NX|SBAR < (CC|CONJP=target !< /either|neither|both|Either|Neither|Both/)"});
    public static final GrammaticalRelation PUNCTUATION = new GrammaticalRelation("punct", "punctuation", GrammaticalRelation.DEPENDENT, "S|NP|VP|SQ|PRN|SINV|SBAR|UCP", new String[]{"__ < /^(?:\\.|:|,|''|``|-LRB-|-RRB-)$/=target"});
    public static final GrammaticalRelation ARGUMENT = new GrammaticalRelation("arg", "argument", GrammaticalRelation.DEPENDENT, null, new String[0]);
    public static final GrammaticalRelation SUBJECT = new GrammaticalRelation("subj", "subject", ARGUMENT, null, new String[0]);
    public static final GrammaticalRelation NOMINAL_SUBJECT = new GrammaticalRelation("nsubj", "nominal subject", SUBJECT, "S|SQ|SBARQ|SINV|SBAR", new String[]{"S < ((NP|WHNP=target !< EX) $++ VP)", "SQ < ((NP=target !< EX) $++ VP)", "SQ < ((NP=target !< EX) $- /^VB/ ![$++ VP])", "SQ < ((NP=target !< EX) $- (RB $- /^VB/) ![$++ VP])", "SBARQ < WHNP=target < (SQ < (VP ![$-- NP]))", "SBARQ < (SQ=target < /^VB/ !< VP)", "SINV < (VP $+ /^(NP|WHNP)$/=target)", "S < (NP=target $+ NP|ADJP) > VP", "SBAR <, WHNP=target < (S < (VP !$-- NP) !< SBAR)", "SBAR !< WHNP < (S !< (NP $++ VP)) > (VP > (S $- WHNP=target))", "SQ < ((NP < EX) $++ NP=target)", "S < (NP < EX) < (VP < NP=target)"});
    public static final GrammaticalRelation NOMINAL_PASSIVE_SUBJECT = new GrammaticalRelation("nsubjpass", "nominal passive subject", NOMINAL_SUBJECT, "S|VP", new String[]{"S < /^(NP|WHNP)$/=target < (VP|SQ < (VP < VBN|VBD) < (/^(VB|AUX)/ < /be|was|is|are|were|been|being|'s|'re|'m|am|Been|Being|WAS|IS|get|got|getting|gets|Get|gotten|becomes|become|became|felt|feels|feel|seems|seem|seemed|remains|remained|remain/))", "S < /^(NP|WHNP)$/=target < (VP|SQ <+(VP) (VP < VBN|VBD > (VP < (/^(VB|AUX)/ < /be|was|is|are|were|been|being|'s|'re|'m|am|Been|Being|WAS|IS|get|got|getting|gets|Get|gotten|becomes|become|became|felt|feels|feel|seems|seem|seemed|remains|remained|remain/))))", "VP <, VBN > NP=target"});
    public static final GrammaticalRelation CLAUSAL_SUBJECT = new GrammaticalRelation("csubj", "clausal subject", SUBJECT, "S", new String[]{"S < (SBAR=target $++ (VP !$-- NP))"});
    public static final GrammaticalRelation COMPLEMENT = new GrammaticalRelation("comp", "complement", ARGUMENT, null, new String[0]);
    public static final GrammaticalRelation OBJECT = new GrammaticalRelation("obj", "object", COMPLEMENT, null, new String[0]);
    public static final GrammaticalRelation DIRECT_OBJECT = new GrammaticalRelation("dobj", "direct object", OBJECT, "SBARQ|VP|SBAR|VBG", new String[]{"VP < (/^NP$/ $+ /^(NP|WHNP)$/=target) !<(/^VB/ < /^(am|is|are|'s|'re|'m|was|were|seem|seems|seemed|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|become|becomes|became)$/) ", "VP < (NP < (/^NP$/ $+ /^(NP|WHNP)$/=target))!< (/^VB/ < /^(am|is|are|'s|'re|'m|was|were|seem|seems|seemed|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|become|becomes|became)$/)", "VP !<(/^VB/ < /^(am|is|are|'s|'re|'m|was|were|seem|seems|seemed|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|become|becomes|became)$/) < (/^(NP|WHNP)$/=target !$+ NP)", "SBARQ <, (WHNP=target !< WRB) << (VP !< (S < (VP < TO)) $-- NP)", "SBAR <, (WHNP=target !< WRB) < (S < NP < (VP !< SBAR !< (S < (VP < TO))))", "SBAR !< WHNP < (S < (NP $++ (VP !$++ NP))) > (VP > (S < NP $- WHNP=target))", "VBG > PP $+ NP=target"});
    public static final GrammaticalRelation INDIRECT_OBJECT = new GrammaticalRelation("iobj", "indirect object", OBJECT, "VP", new String[]{"VP <(NP=target $++ NP)", "VP < (NP=target < (NP $++ NP !$ CC !$ /^,$/ !$++ /^:$/))"});
    public static final GrammaticalRelation PREPOSITIONAL_OBJECT = new GrammaticalRelation("pobj", "prepositional object", OBJECT, "^PP(?:-TMP)?$", new String[]{"/^PP(?:-TMP)?$/ < /^IN|VBG|TO/ < /^NP(?:-TMP)?$/=target"});
    public static final GrammaticalRelation ATTRIBUTIVE = new GrammaticalRelation("attr", "attributive", COMPLEMENT, "VP|SBARQ|SQ", new String[]{"VP !$ (NP < EX) < /NP/=target <(/^VB/ < /^(am|is|are|'s|'re|'m|was|were|seem|seems|seemed|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|become|becomes|became)$/)", "SBARQ < (/WHNP/=target $+ (SQ <(/^VB/ < /^(am|is|are|'s|'re|'m|was|were|seem|seems|seemed|appear|appears|appeared|stay|stays|stayed|remain|remains|remained|resemble|resembles|resembled|become|becomes|became)$/)))", "SQ <, (/^VB/ < /^(Am|am|Is|is|Are|are|'s|'re|'m|Was|was|Were|were)$/) < (NP=target $-- (NP !< EX))"});
    public static final GrammaticalRelation CLAUSAL_COMPLEMENT = new GrammaticalRelation("ccomp", "clausal complement", COMPLEMENT, "VP|SINV|S|ADJP", new String[]{"VP < (S=target < (VP !<, TO|VBG) !$-- NP)", "VP < (SBAR=target < (S <+(S) VP) <, (IN|DT < /^(that|whether)$/))", "VP < (SBAR=target < (S < VP) !$-- NP !<, IN)", "S|SINV < (S=target $+ /^,$/ !$- /^:$/ !< (VP < TO|VBG))", "ADJP < (SBAR=target < (S < VP))"});
    public static final GrammaticalRelation XCLAUSAL_COMPLEMENT = new GrammaticalRelation("xcomp", "xclausal complement", COMPLEMENT, "VP|ADJP", new String[]{"VP !> (VP < (VB < be)) < (S=target < (VP < TO|VBG))", "ADJP < (S=target <, (VP <, TO))", "VP < (S=target < (NP $+ NP|ADJP))", "VP < (/^VB/ $+ (VP=target < VB < NP))"});
    public static final GrammaticalRelation COMPLEMENTIZER = new GrammaticalRelation("complm", "complementizer", COMPLEMENT, "SBAR", new String[]{"SBAR <, (IN|DT=target < /^(that|whether)$/) $-- /^VB/", "SBAR <, (IN|DT=target < /^(that|whether)$/) $- NP", "SBAR <, (IN|DT=target < /^(that|whether)$/) > ADJP"});
    public static final GrammaticalRelation MARKER = new GrammaticalRelation("mark", "marker", COMPLEMENT, "^SBAR(?:-TMP)?$", new String[]{"/^SBAR(?:-TMP)?$/ <, (IN=target !< /^(that|whether)$/) < S"});
    public static final GrammaticalRelation RELATIVE = new GrammaticalRelation("rel", "relative", COMPLEMENT, "SBAR", new String[]{"SBAR <, /^WH/=target > NP"});
    public static final GrammaticalRelation REFERENT = new GrammaticalRelation("ref", "referent", GrammaticalRelation.DEPENDENT, "NP", new String[]{"NP $+ (SBAR < WHNP=target) > NP", "NP $+ (SBAR < (WHPP < WHNP=target)) > NP", "NP $+ (/^(,|PP|PRN)$/ $+ (SBAR < /^WHNP/=target))", "NP $+ (/^(,|PP|PRN)$/ $+ (SBAR < (WHPP < WHNP=target))) > NP"});
    public static final GrammaticalRelation EXPLETIVE = new GrammaticalRelation("expl", "expletive", GrammaticalRelation.DEPENDENT, "S|SQ", new String[]{"S|SQ < (NP=target < EX)"});
    public static final GrammaticalRelation ADJECTIVAL_COMPLEMENT = new GrammaticalRelation("acomp", "adjectival complement", COMPLEMENT, "VP", new String[]{"VP < (ADJP=target !$-- NP)"});
    public static final GrammaticalRelation MODIFIER = new GrammaticalRelation("mod", "modifier", GrammaticalRelation.DEPENDENT, null, new String[0]);
    public static final GrammaticalRelation ADV_CLAUSE_MODIFIER = new GrammaticalRelation("advcl", "adverbial clause modifier", MODIFIER, "VP|S|SQ", new String[]{"VP < (/^SBAR(?:-TMP)?$/=target <, (IN !< /^(that|whether)$/))", "S|SQ <, (/^SBAR(?:-TMP)?$/=target <, (IN !< /^(that|whether)$/))", "S|SQ <, (/^SBAR(?:-TMP)?$/=target <2 (IN !< /^(that|whether)$/))", "S|SQ <, (SBAR=target <, (WHADVP|WHNP < WRB))"});
    public static final GrammaticalRelation PURPOSE_CLAUSE_MODIFIER = new GrammaticalRelation("purpcl", "purpose clause modifier", MODIFIER, "VP", new String[]{"VP < (/^SBAR/=target < (IN < in) < (NN < order) < (S < (VP < TO)))", "VP > (VP < (VB < be)) < (S=target < (VP < TO|VBG) !$-- NP)"});
    public static final GrammaticalRelation TEMPORAL_MODIFIER = new GrammaticalRelation("tmod", "temporal modifier", MODIFIER, "VP|S|ADJP", new String[]{"VP|ADJP < /^NP-TMP$/=target", "S < (/^NP-TMP$/=target $++ (NP $++ VP))"});
    public static final GrammaticalRelation RELATIVE_CLAUSE_MODIFIER = new GrammaticalRelation("rcmod", "relative clause modifier", MODIFIER, "NP", new String[]{"NP $++ (SBAR=target < WHPP|WHNP) > NP", "NP $++ (SBAR=target <: S) > NP", "NP $++ (SBAR=target < (IN < /^that$/))", "NP $++ (SBAR=target < (WHADVP < (WRB </^(where|why)/))) > NP"});
    public static final GrammaticalRelation ADJECTIVAL_MODIFIER = new GrammaticalRelation("amod", "adjectival modifier", MODIFIER, "^NP(?:-TMP)?|NP(?:-ADV)?|NX|WHNP$", new String[]{"/^NP(?:-TMP)?|NP(?:-ADV)?|NX|WHNP$/ < (ADJP|WHADJP|JJ|JJR|JJS|VBN|VBG|VBD=target !$- CC)"});
    public static final GrammaticalRelation NUMERIC_MODIFIER = new GrammaticalRelation("num", "numeric modifier", MODIFIER, "^NP(?:-TMP)?|NP(?:-ADV)?$", new String[]{"/^NP(?:-TMP)?|NP(?:-ADV)?$/ < CD|QP=target", "/^NP(?:-TMP)?|NP(?:-ADV)?$/ < (ADJP=target <: QP)"});
    public static final GrammaticalRelation NUMBER_MODIFIER = new GrammaticalRelation("number", "compound number modifier", MODIFIER, "QP", new String[]{"QP < CD=target"});
    public static final GrammaticalRelation NOUN_COMPOUND_MODIFIER = new GrammaticalRelation("nn", "nn modifier", MODIFIER, "^NP(?:-TMP)?|NP(?:-ADV)?$", new String[]{"/^NP(?:-TMP)?|NP(?:-ADV)?$/ < (NP|NN|NNS|NNP|NNPS|FW=target $+ NN|NNS|NNP|NNPS|FW !<- POS)", "/^NP(?:-TMP)?|NP(?:-ADV)?$/ < (NP|NN|NNS|NNP|NNPS|FW=target !<- POS $+ JJ|JJR|JJS) <# NN|NNS|NNP|NNPS !<- POS"});
    public static final GrammaticalRelation APPOSITIONAL_MODIFIER = new GrammaticalRelation("appos", "appositional modifier", MODIFIER, "^NP(?:-TMP)?|NP(?:-ADV)?$", new String[]{"/^NP(?:-TMP)?|NP(?:-ADV)?$/ < (NP=target $- /^,$/ $-- NP !$ CC|CONJP)", "/^NP(?:-TMP)?|NP(?:-ADV)?$/ < (PRN < (NP=target < /^NNS?/ $-- /^-LRB-$/ $+ /^-RRB-$/))"});
    public static final GrammaticalRelation ABBREVIATION_MODIFIER = new GrammaticalRelation("abbrev", "abbreviation modifier", APPOSITIONAL_MODIFIER, "^NP(?:-TMP)?|NP(?:-ADV)?$", new String[]{"/^NP(?:-TMP)?|NP(?:-ADV)?$/ < (PRN=target < (NP < NNP $- /^-LRB-$/ $+ /^-RRB-$/))", "/^NP(?:-TMP)?|NP(?:-ADV)?$/ < (PRN=target < (NNP $- /^-LRB-$/ $+ /^-RRB-$/))"});
    public static final GrammaticalRelation PARTICIPIAL_MODIFIER = new GrammaticalRelation("partmod", "participial modifier", MODIFIER, "^NP(?:-TMP)?|NP(?:-ADV)?|VP$", new String[]{"/^NP(?:-TMP)?|NP(?:-ADV)?$/ < (VP=target $-- NP)", "VP < (S=target !< NP < (VP < VBG))"});
    public static final GrammaticalRelation INFINITIVAL_MODIFIER = new GrammaticalRelation("infmod", "infinitival modifier", MODIFIER, "^NP(-TMP)?|NP(?:-ADV)?$", new String[]{"/^NP(?:-[A-Z]+)?$/ < (S=target < (VP < TO) $-- /^NP|NNP?S?$/)"});
    public static final GrammaticalRelation ADVERBIAL_MODIFIER = new GrammaticalRelation("advmod", "adverbial modifier", MODIFIER, "VP|ADJP|S|SBAR|SINV|SQ|SBARQ|WHADJP|QP|NP(?:-TMP)?|NP(?:-ADV)?", new String[]{"/^VP|ADJP|S|SBAR|SINV|SQ|NP(?:-TMP)?|NP(?:-ADV)?$/ < RB|ADVP|WHADVP=target", "SBAR < (WHNP=target < WRB)", "/^VP|ADJP|WHADJP|NP(?:-TMP)?|NP(?:-ADV)?$/ < /^RB|WRB/=target", "SBARQ <, WHADVP=target", "QP < RB=target"});
    public static final GrammaticalRelation NEGATION_MODIFIER = new GrammaticalRelation("neg", "negation modifier", ADVERBIAL_MODIFIER, "VP|ADJP|S|SBAR|SINV|SQ", new String[]{"VP|ADJP|SQ|S < (RB=target < /not|n't|never/)", "VP|ADJP|S|SBAR|SINV < (ADVP=target < (RB < /not|n't|never/))", "VP > SQ  $-- (RB=target < /not|n't|never/)"});
    public static final GrammaticalRelation DETERMINER = new GrammaticalRelation("det", "determiner", MODIFIER, "^NP(?:-TMP)?$|NP(?:-ADV)?|WHNP", new String[]{"/^NP(?:-TMP)?|NP(?:-ADV)?$/ < (DT=target !</both|either|neither/ !$- DT !$++ CC $++ /^N[NX]/)", "/^NP(?:-TMP)?|NP(?:-ADV)?$/ < (DT=target < /both|either|neither/ !$- DT !$++ CC $++ /^N[NX]/ !$++ (NP < CC))", "/^NP(?:-TMP)?|NP(?:-ADV)?$/ < (DT=target !< /both|neither|either/ $++ CC $++ /^N[NX]/)", "/^NP(?:-TMP)?|NP(?:-ADV)?$/ < (DT=target $++ (/^JJ/ !$+ /^NN/) !$++CC)", "/^NP(?:-TMP)|NP(?:-ADV)?$/ < (RB=target $++ (/P?DT/ $+ /^NN/))", "WHNP < (NP $-- (WHNP=target < WDT))", "WHNP < (NN $-- WDT=target)"});
    public static final GrammaticalRelation PREDETERMINER = new GrammaticalRelation("predet", "predeterminer", MODIFIER, "^NP(?:-TMP)?$|NP(?:-ADV)?", new String[]{"/^NP(?:-TMP)?|NP(?:-ADV)?$/ < (PDT|DT=target $+ /DT|PRP\\$/ $++ /^N[NX]/ !$++ CC)", "/^NP(?:-TMP)?|NP(?:-ADV)?$/ < (PDT|DT=target $+ DT $++ (/^JJ/ !$+ /^NN/)) !$++ CC"});
    public static final GrammaticalRelation PRECONJUNCT = new GrammaticalRelation("preconj", "preconjunct", MODIFIER, "S|VP|ADJP|PP|ADVP|UCP|NX|SBAR|^NP(?:-TMP)?$|NP(?:-ADV)?", new String[]{"/^NP(?:-TMP)?|NP(?:-ADV)?|NX$/ < (PDT|CC=target < /both|neither|either/ $++ /^N[NX]/) $++ CC", "/^NP(?:-TMP)?|NP(?:-ADV)?|NX$/ < (PDT|CC=target < /both|either|neither/ $++ (/^JJ/ !$+ /^NN/)) $++ CC", "/^NP(?:-TMP)?|NP(?:-ADV)?|NX$/ < (PDT|CC|DT=target < /both|either|neither/ $++ CC)", "/^NP(?:-TMP)?|NP(?:-ADV)?|NX$/ < (PDT|CC|DT=target </both|either|neither/) < (NP < CC)", "S|VP|ADJP|PP|ADVP|UCP|NX|SBAR < (PDT|DT|CC=target < /both|either|neither/ $++ CC)"});
    public static final GrammaticalRelation POSSESSION_MODIFIER = new GrammaticalRelation("poss", "possession modifier", MODIFIER, "^NP(?:-TMP)?|NP(?:-ADV)?$", new String[]{"/^NP(?:-TMP)?|NP(?:-ADV)?$/ < (/^PRP\\$/=target $++ /^NN/)", "/^NP(-TMP)?|NP(?:-ADV)?$/ < (NP=target < POS)", "/^NP(-TMP)?|NP(?:-ADV)?$/ < (NNS=target $+ (POS < /'/))"});
    public static final GrammaticalRelation POSSESSIVE_MODIFIER = new GrammaticalRelation("possessive", "possessive modifier", MODIFIER, "^NP(?:-TMP)?|NP(?:-ADV)?$", new String[]{"/^NP(?:-TMP)?|NP(?:-ADV)?$/ <- POS=target"});
    public static final GrammaticalRelation PREPOSITIONAL_MODIFIER = new GrammaticalRelation("prep", "prepositional modifier", MODIFIER, "^NP(?:-TMP)?|NP(?:-ADV)?|VP|S$", new String[]{"/^NP(?:-TMP)?|NP(?:-ADV)?$/ < /^PP(?:-TMP)?$/=target", "VP < /^PP(?:-TMP)?$/=target", "S < (/^PP(?:-TMP)?$/=target !< SBAR) < VP"});
    public static final GrammaticalRelation PHRASAL_VERB_PARTICLE = new GrammaticalRelation("prt", "phrasal verb particle", MODIFIER, "VP", new String[]{"VP < PRT=target"});
    public static final GrammaticalRelation SEMANTIC_DEPENDENT = new GrammaticalRelation("sdep", "semantic dependent", GrammaticalRelation.DEPENDENT, null, new String[0]);
    public static final GrammaticalRelation CONTROLLING_SUBJECT = new GrammaticalRelation("xsubj", "controlling subject", SEMANTIC_DEPENDENT, "VP", new String[]{"VP < TO > (S !$- NP !< NP !>> (VP < (VB < be)) >+(VP) (VP $-- NP=target))"});
    public static final GrammaticalRelation AGENT = new GrammaticalRelation("agent", "agent", GrammaticalRelation.DEPENDENT, null, new String[0]);
    private static final GrammaticalRelation[] values = new GrammaticalRelation[]{GrammaticalRelation.GOVERNOR, GrammaticalRelation.DEPENDENT, PREDICATE, ATTRIBUTIVE, AUX_MODIFIER, AUX_PASSIVE_MODIFIER, COPULA, CONJUNCT, COORDINATION, PUNCTUATION, ARGUMENT, SUBJECT, NOMINAL_SUBJECT, NOMINAL_PASSIVE_SUBJECT, CLAUSAL_SUBJECT, COMPLEMENT, OBJECT, DIRECT_OBJECT, INDIRECT_OBJECT, PREPOSITIONAL_OBJECT, CLAUSAL_COMPLEMENT, XCLAUSAL_COMPLEMENT, COMPLEMENTIZER, MARKER, RELATIVE, REFERENT, EXPLETIVE, ADJECTIVAL_COMPLEMENT, MODIFIER, ADV_CLAUSE_MODIFIER, TEMPORAL_MODIFIER, RELATIVE_CLAUSE_MODIFIER, NUMERIC_MODIFIER, ADJECTIVAL_MODIFIER, NOUN_COMPOUND_MODIFIER, APPOSITIONAL_MODIFIER, ABBREVIATION_MODIFIER, PARTICIPIAL_MODIFIER, INFINITIVAL_MODIFIER, ADVERBIAL_MODIFIER, NEGATION_MODIFIER, DETERMINER, PREDETERMINER, PRECONJUNCT, POSSESSION_MODIFIER, POSSESSIVE_MODIFIER, PREPOSITIONAL_MODIFIER, PHRASAL_VERB_PARTICLE, SEMANTIC_DEPENDENT, CONTROLLING_SUBJECT, AGENT, NUMBER_MODIFIER, PURPOSE_CLAUSE_MODIFIER};
    private static final Map<String, GrammaticalRelation> conjs = new HashMap<String, GrammaticalRelation>();
    private static final Map<String, GrammaticalRelation> preps = new HashMap<String, GrammaticalRelation>();

    public static List<GrammaticalRelation> values() {
        return Collections.unmodifiableList(Arrays.asList(values));
    }

    public static Collection<GrammaticalRelation> getConjs() {
        return conjs.values();
    }

    public static GrammaticalRelation getConj(String conjunctionString) {
        GrammaticalRelation result = conjs.get(conjunctionString);
        if (result == null) {
            result = new GrammaticalRelation("conj", "conj_collapsed", GrammaticalRelation.DEPENDENT, null, StringUtils.EMPTY_STRING_ARRAY, conjunctionString);
            conjs.put(conjunctionString, result);
        }
        return result;
    }

    public static Collection<GrammaticalRelation> getPreps() {
        return preps.values();
    }

    public static GrammaticalRelation getPrep(String prepositionString) {
        GrammaticalRelation result = preps.get(prepositionString);
        if (result == null) {
            result = new GrammaticalRelation("prep", "prep_collapsed", GrammaticalRelation.DEPENDENT, null, StringUtils.EMPTY_STRING_ARRAY, prepositionString);
            preps.put(prepositionString, result);
        }
        return result;
    }

    public static GrammaticalRelation valueOf(String s) {
        for (GrammaticalRelation reln : values) {
            if (!reln.toString().equals(s)) continue;
            return reln;
        }
        return null;
    }

    public static GrammaticalRelation valueOf(Object o) {
        if (o instanceof GrammaticalRelation) {
            return (GrammaticalRelation)o;
        }
        if (o instanceof String) {
            return EnglishGrammaticalRelations.valueOf((String)o);
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(GrammaticalRelation.DEPENDENT.toPrettyString());
    }
}

