/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.tagger.maxent.FeatureKey;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.ListInstances;
import edu.stanford.nlp.tagger.maxent.TaggerExperiments;
import edu.stanford.nlp.util.Pair;
import java.util.HashMap;

public class TemplateHash {
    HashMap tempHash = new HashMap();
    int size;
    public static String[] stringNums;

    public void addPositions(int start, int end, FeatureKey fK) {
        Pair<Integer, String> key = new Pair<Integer, String>(new Integer(fK.num), fK.val);
        ((ListInstances)this.tempHash.get(key)).addPositions(start, end);
    }

    public int[] getPositions(FeatureKey s) {
        Pair<Integer, String> p = new Pair<Integer, String>(new Integer(s.num), s.val);
        return ((ListInstances)this.tempHash.get(p)).getPositions();
    }

    public void init() {
        int num = GlobalHolder.extractors.getSize() + GlobalHolder.extractorsRare.getSize();
        stringNums = new String[num];
        int i = 0;
        while (i < num) {
            TemplateHash.stringNums[i] = String.valueOf(i);
            ++i;
        }
    }

    public void release() {
        this.tempHash.clear();
    }

    public void add(int nFeatFrame, History history, int number) {
        int general = GlobalHolder.extractors.getSize();
        Pair<Integer, String> wT = nFeatFrame < general ? new Pair<Integer, String>(new Integer(nFeatFrame), GlobalHolder.extractors.extract(nFeatFrame, history)) : new Pair<Integer, String>(new Integer(nFeatFrame), GlobalHolder.extractorsRare.extract(nFeatFrame - general, history));
        if (this.tempHash.containsKey(wT)) {
            ListInstances li = (ListInstances)this.tempHash.get(wT);
            if (TaggerExperiments.populated(nFeatFrame, li.getNum())) {
                li.add(number);
            }
        } else {
            ListInstances li = new ListInstances();
            li.add(number);
            this.tempHash.put(wT, li);
            ++this.size;
        }
    }

    public void addPrev(int nFeatFrame, History history, int number) {
        Pair<Integer, String> wT = null;
        int general = GlobalHolder.extractors.getSize();
        wT = nFeatFrame < general ? new Pair<Integer, String>(new Integer(nFeatFrame), GlobalHolder.extractors.extract(nFeatFrame, history)) : new Pair<Integer, String>(new Integer(nFeatFrame), GlobalHolder.extractorsRare.extract(nFeatFrame - general, history));
        if (this.tempHash.containsKey(wT)) {
            ((ListInstances)this.tempHash.get(wT)).inc();
        } else {
            ListInstances li = new ListInstances();
            li.inc();
            this.tempHash.put(wT, li);
            ++this.size;
        }
    }

    public int[] getXValues(Object key) {
        if (this.tempHash.containsKey(key)) {
            return ((ListInstances)this.tempHash.get(key)).getInstances();
        }
        return null;
    }

    public void save(OutDataStreamFile rf) {
        try {
            Object[] keys = this.tempHash.keySet().toArray();
            rf.writeInt(keys.length);
            int i = 0;
            while (i < keys.length) {
                Pair s = (Pair)keys[i];
                s.save(rf);
                ((ListInstances)this.tempHash.get(keys[i])).save(rf);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(InDataStreamFile rf) {
        try {
            int numElem = rf.readInt();
            int i = 0;
            while (i < numElem) {
                Pair<String, String> wT = Pair.readStringPair(rf);
                ListInstances li = new ListInstances();
                li.read(rf);
                this.tempHash.put(wT, li);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void print() {
        Object[] arr = this.tempHash.keySet().toArray();
        int i = 0;
        while (i < arr.length) {
            System.out.println(arr[i]);
            ++i;
        }
    }

    public static void main(String[] args) {
        TemplateHash hT = new TemplateHash();
        String s = "0";
        hT.tempHash.put(s, "1");
        if (hT.tempHash.containsKey(s)) {
            System.out.println(hT.tempHash.get(s));
        }
    }
}

