/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.maxent.BinaryFeature;
import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.TestSentence;

class RareExtractor
extends Extractor {
    public static final String naTag = TestSentence.toSt("NA");
    private static final long serialVersionUID = -7682607870855426599L;

    RareExtractor() {
    }

    public boolean isPopulated(BinaryFeature f) {
        return f.indexedValues.length > GlobalHolder.thresholdRare;
    }

    public static boolean startsUpperCase(String s) {
        if (s == null) {
            return false;
        }
        char ch = s.charAt(0);
        return Character.isUpperCase(ch);
    }

    public static boolean startsLowerCase(String s) {
        if (s == null) {
            return false;
        }
        char ch = s.charAt(0);
        return Character.isLowerCase(ch);
    }

    public static boolean containsDash(String s) {
        if (s == null) {
            return false;
        }
        return s.indexOf("-") >= 0;
    }

    public static boolean containsNumber(String s) {
        if (s == null) {
            return false;
        }
        int i = 0;
        int len = s.length();
        while (i < len) {
            if (Character.isDigit(s.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsLetter(String s) {
        if (s == null) {
            return false;
        }
        int i = 0;
        int len = s.length();
        while (i < len) {
            if (Character.isLetter(s.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsUpperCase(String s) {
        if (s == null) {
            return false;
        }
        int i = 0;
        int len = s.length();
        while (i < len) {
            if (Character.isUpperCase(s.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean allUpperCase(String s) {
        if (s == null) {
            return false;
        }
        int i = 0;
        int len = s.length();
        while (i < len) {
            if (!Character.isUpperCase(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean noneLowerCase(String s) {
        if (s == null) {
            return false;
        }
        int i = 0;
        int len = s.length();
        while (i < len) {
            if (Character.isLowerCase(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

