/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.RareExtractor;

class PluralAcronymDetector
extends RareExtractor {
    private static final long serialVersionUID = 33L;

    private static boolean pluralAcronym(String s) {
        int len = s.length();
        if (s.charAt(--len) != 's') {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (!Character.isUpperCase(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    String extract(History h, PairsHolder pH) {
        String s = pH.get(h, 0, false);
        if (PluralAcronymDetector.pluralAcronym(s)) {
            return "1";
        }
        return "0";
    }
}

