/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.maxent.Convert;
import edu.stanford.nlp.maxent.Experiments;
import edu.stanford.nlp.maxent.Feature;
import edu.stanford.nlp.maxent.Problem;
import edu.stanford.nlp.maxent.iis.LambdaSolve;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.TaggerExperiments;
import edu.stanford.nlp.tagger.maxent.TaggerFeature;
import edu.stanford.nlp.util.MutableDouble;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.text.NumberFormat;
import java.util.HashMap;

public class LambdaSolveTagger
extends LambdaSolve {
    private static final boolean VERBOSE = false;

    LambdaSolveTagger(Problem p1, double eps1, double nerr1) {
        this.p = p1;
        this.eps = eps1;
        this.newtonerr = nerr1;
        this.lambda = new double[p1.fSize];
        this.lambda_converged = new boolean[p1.fSize];
        Experiments cfr_ignored_0 = this.p.data;
        Experiments cfr_ignored_1 = this.p.data;
        this.probConds = new double[Experiments.xSize][Experiments.ySize];
        this.fnumArr = GlobalHolder.fnumArr;
        Experiments cfr_ignored_2 = this.p.data;
        this.zlambda = new double[Experiments.xSize];
        this.ftildeArr = new double[this.p.fSize];
        this.initCondsZlambdaEtc();
    }

    LambdaSolveTagger(String filename) {
        this.readL(filename);
    }

    public void readOldLambdas(String filename, String oldfilename) {
        double[] lambdaold = this.read_lambdas(oldfilename);
        HashMap oldAssocs = GlobalHolder.readAssociations(oldfilename);
        HashMap newAssocs = GlobalHolder.readAssociations(filename);
        Object[] arrStrings = oldAssocs.keySet().toArray();
        int i = 0;
        while (i < arrStrings.length) {
            int numOld = GlobalHolder.getNum(arrStrings[i], oldAssocs);
            int numNew = GlobalHolder.getNum(arrStrings[i], newAssocs);
            if (numOld > -1 && numNew > -1) {
                this.lambda[numNew] = lambdaold[numOld];
                this.updateConds(numNew, lambdaold[numOld]);
            }
            ++i;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    void initCondsZlambdaEtc() {
        block12: {
            int x;
            block11: {
                block8: {
                    block7: {
                        x = 0;
                        if (!true) break block7;
                        Experiments cfr_ignored_0 = this.p.data;
                        if (x >= Experiments.xSize) break block8;
                    }
                    do {
                        block10: {
                            int y;
                            block9: {
                                y = 0;
                                if (!true) break block9;
                                Experiments cfr_ignored_1 = this.p.data;
                                if (y >= Experiments.ySize) break block10;
                            }
                            do {
                                Experiments cfr_ignored_2 = this.p.data;
                                this.probConds[x][y] = 1.0 / (double)Experiments.ySize;
                                ++y;
                                Experiments cfr_ignored_3 = this.p.data;
                            } while (y < Experiments.ySize);
                        }
                        ++x;
                        Experiments cfr_ignored_4 = this.p.data;
                    } while (x < Experiments.xSize);
                }
                System.out.println(" pcond initialized ");
                x = 0;
                if (!true) break block11;
                Experiments cfr_ignored_5 = this.p.data;
                if (x >= Experiments.xSize) break block12;
            }
            do {
                Experiments cfr_ignored_6 = this.p.data;
                this.zlambda[x] = Experiments.ySize;
                ++x;
                Experiments cfr_ignored_7 = this.p.data;
            } while (x < Experiments.xSize);
        }
        System.out.println(" zlambda initialized ");
        int i = 0;
        while (i < this.p.fSize) {
            this.ftildeArr[i] = this.p.functions.get(i).ftilde();
            if (this.ftildeArr[i] == 0.0) {
                System.out.println(" Empirical expectation 0 for feature " + i);
            }
            ++i;
        }
        System.out.println(" ftildeArr initialized ");
    }

    boolean Iterate(int index, double err, MutableDouble ret) {
        double deltaL = 0.0;
        deltaL = this.newton(deltaL, index, err);
        this.lambda[index] = this.lambda[index] + deltaL;
        if (deltaL != deltaL) {
            System.out.println(" NaN " + index + " " + deltaL);
        }
        ret.set(deltaL);
        return Math.abs(deltaL) >= this.eps;
    }

    double newton(double lambda0, int index, double err) {
        double lambdaN = lambda0;
        int i = 0;
        double gVal = 0.0;
        do {
            ++i;
            double lambdaP = lambdaN;
            double gPrimeVal = this.gprime(lambdaP, index);
            if (gPrimeVal != gPrimeVal) {
                System.out.println("gPrime of " + lambdaP + " " + index + " is NaN " + gPrimeVal);
            }
            gVal = this.g(lambdaP, index);
            if (gPrimeVal == 0.0) {
                return 0.0;
            }
            lambdaN = lambdaP - gVal / gPrimeVal;
            if (lambdaN != lambdaN) {
                System.out.println("the division of " + gVal + " " + gPrimeVal + " " + index + " is NaN " + lambdaN);
                return 0.0;
            }
            if (!(Math.abs(lambdaN - lambdaP) < err)) continue;
            return lambdaN;
        } while (i <= 100);
        if (Math.abs(gVal) > 1.0) {
            return 0.0;
        }
        return lambdaN;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    void updateConds(int index, double deltaL) {
        int yTag = ((TaggerFeature)this.p.functions.get(index)).getYTag();
        int i = 0;
        while (i < this.p.functions.get(index).len()) {
            double zlambdaX;
            int x;
            double s;
            block5: {
                int y;
                block4: {
                    s = 0.0;
                    x = this.p.functions.get(index).getX(i);
                    zlambdaX = this.zlambda[x] + this.pcond(yTag, x) * this.zlambda[x] * (Math.exp(deltaL) - 1.0);
                    y = 0;
                    if (!true) break block4;
                    Experiments cfr_ignored_0 = this.p.data;
                    if (y >= Experiments.ySize) break block5;
                }
                do {
                    this.probConds[x][y] = this.probConds[x][y] * this.zlambda[x] / zlambdaX;
                    s += this.probConds[x][y];
                    ++y;
                    Experiments cfr_ignored_1 = this.p.data;
                } while (y < Experiments.ySize);
            }
            s -= this.probConds[x][yTag];
            this.probConds[x][yTag] = this.probConds[x][yTag] * Math.exp(deltaL);
            s += this.probConds[x][yTag];
            this.zlambda[x] = zlambdaX;
            if (Math.abs(s - 1.0) > 0.001) {
                // empty if block
            }
            ++i;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    double pcondCalc(int y, int x) {
        double zlambdaX;
        block5: {
            int y1;
            block4: {
                zlambdaX = 0.0;
                y1 = 0;
                if (!true) break block4;
                Experiments cfr_ignored_0 = this.p.data;
                if (y1 >= Experiments.ySize) break block5;
            }
            do {
                double s = 0.0;
                int i = 0;
                while (i < this.p.fSize) {
                    s += this.lambda[i] * this.p.functions.get(i).getVal(x, y1);
                    ++i;
                }
                zlambdaX += Math.exp(s);
                ++y1;
                Experiments cfr_ignored_1 = this.p.data;
            } while (y1 < Experiments.ySize);
        }
        double s = 0.0;
        int i = 0;
        while (i < this.p.fSize) {
            s += this.lambda[i] * this.p.functions.get(i).getVal(x, y);
            ++i;
        }
        return 1.0 / zlambdaX * Math.exp(s);
    }

    double fnumCalc(int x, int y) {
        double s = 0.0;
        int i = 0;
        while (i < this.p.fSize) {
            s += this.p.functions.get(i).getVal(x, y);
            ++i;
        }
        return s;
    }

    double g(double lambdaP, int index) {
        double s = 0.0;
        int i = 0;
        while (i < this.p.functions.get(index).len()) {
            int y = ((TaggerFeature)this.p.functions.get(index)).getYTag();
            int x = this.p.functions.get(index).getX(i);
            s += this.p.data.ptildeX(x) * this.pcond(y, x) * 1.0 * Math.exp(lambdaP * this.fnum(x, y));
            ++i;
        }
        return s -= this.ftildeArr[index];
    }

    double gprime(double lambdaP, int index) {
        double s = 0.0;
        int i = 0;
        while (i < this.p.functions.get(index).len()) {
            int y = ((TaggerFeature)this.p.functions.get(index)).getYTag();
            int x = this.p.functions.get(index).getX(i);
            s += this.p.data.ptildeX(x) * this.pcond(y, x) * 1.0 * Math.exp(lambdaP * this.fnum(x, y)) * this.fnum(x, y);
            ++i;
        }
        return s;
    }

    double fExpected(Feature f) {
        TaggerFeature tF = (TaggerFeature)f;
        double s = 0.0;
        int y = tF.getYTag();
        int i = 0;
        while (i < f.len()) {
            int x = tF.getX(i);
            s += this.p.data.ptildeX(x) * this.pcond(y, x);
            ++i;
        }
        return s;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean checkCorrectness() {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(4);
        boolean flag = true;
        int f = 0;
        while (f < this.lambda.length) {
            if (Math.abs(this.lambda[f]) > 100.0) {
                System.out.println(" Lambda too big " + this.lambda[f]);
                System.out.println(" empirical " + this.ftildeArr[f] + " expected " + this.fExpected(this.p.functions.get(f)));
            }
            ++f;
        }
        System.out.println(" x size" + TaggerExperiments.xSize + " " + " ysize " + TaggerExperiments.ySize);
        int i = 0;
        while (i < this.ftildeArr.length) {
            double exp = Math.abs(this.ftildeArr[i] - this.fExpected(this.p.functions.get(i)));
            if (exp > 0.001) {
                flag = false;
                System.out.println("Constraint " + i + " not satisfied emp " + nf.format(this.ftildeArr[i]) + " exp " + nf.format(this.fExpected(this.p.functions.get(i))) + " diff " + nf.format(exp) + " lambda " + nf.format(this.lambda[i]));
            }
            ++i;
        }
        int x = 0;
        while (x < TaggerExperiments.xSize) {
            double s = 0.0;
            int y = 0;
            while (y < TaggerExperiments.ySize) {
                s += this.probConds[x][y];
                ++y;
            }
            if (Math.abs(s - 1.0) > 1.0E-4) {
                y = 0;
                while (y < TaggerExperiments.ySize) {
                    System.out.println(String.valueOf(y) + " : " + this.probConds[x][y]);
                    ++y;
                }
                System.out.println("probabilities do not sum to one " + x + " " + (float)s);
            }
            ++x;
        }
        return flag;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    double ZAlfa(double alfa, Feature f, int x) {
        double s;
        block3: {
            int y;
            block2: {
                s = 0.0;
                y = 0;
                if (!true) break block2;
                Experiments cfr_ignored_0 = this.p.data;
                if (y >= Experiments.ySize) break block3;
            }
            do {
                s += this.pcond(y, x) * Math.exp(alfa * f.getVal(x, y));
                ++y;
                Experiments cfr_ignored_1 = this.p.data;
            } while (y < Experiments.ySize);
        }
        return s;
    }

    double[] read_lambdas(String modelFilename) {
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(String.valueOf(modelFilename) + ".holder.prob"));
            dis.readInt();
            dis.readInt();
            int funsize = dis.readInt();
            byte[] b = new byte[funsize * 8];
            dis.read(b);
            double[] lambdaold = Convert.byteArrToDoubleArr(b);
            dis.close();
            return lambdaold;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

