/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.maxent.Features;
import edu.stanford.nlp.maxent.Problem;
import edu.stanford.nlp.maxent.iis.LambdaSolve;
import edu.stanford.nlp.tagger.maxent.AmbiguityClasses;
import edu.stanford.nlp.tagger.maxent.CollectionTaggerOutputs;
import edu.stanford.nlp.tagger.maxent.Dictionary;
import edu.stanford.nlp.tagger.maxent.ExtractorFrames;
import edu.stanford.nlp.tagger.maxent.ExtractorFramesRare;
import edu.stanford.nlp.tagger.maxent.Extractors;
import edu.stanford.nlp.tagger.maxent.FeatureKey;
import edu.stanford.nlp.tagger.maxent.HistoryTable;
import edu.stanford.nlp.tagger.maxent.LambdaSolveTagger;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.TTags;
import edu.stanford.nlp.tagger.maxent.TaggerExperiments;
import edu.stanford.nlp.tagger.maxent.TemplateHash;
import edu.stanford.nlp.tagger.maxent.TestSentence;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class GlobalHolder {
    static TaggerExperiments domain;
    static Dictionary dict;
    static TTags tags;
    static byte[][] fnumArr;
    static LambdaSolveTagger prob;
    static HashSet sTemplates;
    static HashMap fAssociations;
    static HistoryTable tHistories;
    static TemplateHash tFeature;
    static PairsHolder pairs;
    static Extractors extractors;
    static Extractors extractorsRare;
    static AmbiguityClasses ambClasses;
    static CollectionTaggerOutputs collectionTaggers;
    static boolean alltags;
    static int rareThreshold;
    static int threshold;
    static int tresholdCW;
    static int thresholdRare;
    static int threshVeryCommon;
    static int xSize;
    static int ySize;
    static boolean occuringTagsOnly;
    static boolean generateWords;
    static boolean initted;
    static final boolean VERBOSE = false;

    static {
        dict = new Dictionary();
        sTemplates = new HashSet();
        fAssociations = new HashMap();
        tHistories = new HistoryTable();
        tFeature = new TemplateHash();
        pairs = new PairsHolder();
        ambClasses = new AmbiguityClasses();
        collectionTaggers = new CollectionTaggerOutputs(0);
        alltags = false;
        rareThreshold = 5;
        threshold = 5;
        tresholdCW = 2;
        thresholdRare = 10;
        threshVeryCommon = 250;
        occuringTagsOnly = false;
        generateWords = false;
        initted = false;
    }

    public static LambdaSolve getLambdaSolve() {
        return prob;
    }

    public static void init() {
        GlobalHolder.init("english", "left3words");
    }

    public static void init(String lang, String arch) {
        if (initted) {
            return;
        }
        extractors = new Extractors();
        extractorsRare = new Extractors();
        tags = new TTags(lang);
        if (arch.equalsIgnoreCase("left3words")) {
            extractors.init(ExtractorFrames.eFrames_left3words);
            extractorsRare.init(ExtractorFramesRare.eFrames);
        } else if (arch.equalsIgnoreCase("bidirectional")) {
            extractors.init(ExtractorFrames.eFrames_bidirectional);
            extractorsRare.init(ExtractorFramesRare.eFrames);
        } else if (arch.equalsIgnoreCase("sighan2005")) {
            extractors.init(ExtractorFrames.eFrames_sighan2005);
            ExtractorFramesRare.addSighanChineseFeatures();
            extractorsRare.init(ExtractorFramesRare.eFrames);
        } else {
            throw new RuntimeException("arch must be one of 'left3words', 'bidirectional' or 'sighan2005': " + arch);
        }
        initted = true;
    }

    public static boolean add(Object s) {
        if (sTemplates.contains(s)) {
            return false;
        }
        sTemplates.add(s);
        return true;
    }

    public static void putAssoc(FeatureKey s, int num) {
        fAssociations.put(s, new Integer(num));
    }

    public static int getNum(Object s) {
        return GlobalHolder.getNum(s, fAssociations);
    }

    public static int getNum(Object s, HashMap fAssocs) {
        Integer num = (Integer)fAssocs.get(s);
        if (num == null) {
            return -1;
        }
        return num;
    }

    public static void saveExtractors(String filename) throws Exception {
        ObjectOutputStream out2 = new ObjectOutputStream(new FileOutputStream(filename));
        System.out.println(String.valueOf(extractors.toString()) + "\nrare" + extractorsRare.toString());
        out2.writeObject(extractors);
        out2.writeObject(extractorsRare);
        out2.close();
    }

    public static void readExtractors(String filename) throws Exception {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(filename));
        try {
            extractors = (Extractors)in.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        extractorsRare = (Extractors)in.readObject();
        int left = extractors.leftContext();
        int left_u = extractorsRare.leftContext();
        if (left_u > left) {
            left = left_u;
        }
        TestSentence.leftContext = left;
        int right = extractors.rightContext();
        int right_u = extractorsRare.rightContext();
        if (right_u > right) {
            right = right_u;
        }
        TestSentence.rightContext = right;
        in.close();
    }

    public static void save(String filename) {
        try {
            OutDataStreamFile rf = new OutDataStreamFile(filename);
            rf.writeInt(xSize);
            rf.writeInt(ySize);
            rf.close();
            dict.save(String.valueOf(filename) + ".dict");
            tags.save(String.valueOf(filename) + ".tags");
            pairs.save(String.valueOf(filename) + ".pairs");
            tHistories.save(String.valueOf(filename) + ".th");
            GlobalHolder.saveExtractors(String.valueOf(filename) + ".ex");
            ambClasses.save(String.valueOf(filename) + ".acls");
            ambClasses.print();
            OutDataStreamFile tFile = new OutDataStreamFile(String.valueOf(filename) + ".ft");
            tFeature.save(tFile);
            tFile.close();
            prob.save_lambdas(String.valueOf(filename) + ".prob");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void save_prev(String filename) {
        try {
            OutDataStreamFile rf = new OutDataStreamFile(filename);
            rf.writeInt(xSize);
            rf.writeInt(ySize);
            dict.save(String.valueOf(filename) + ".dict");
            tags.save(String.valueOf(filename) + ".tags");
            GlobalHolder.saveExtractors(String.valueOf(filename) + ".ex");
            rf.writeInt(fAssociations.size());
            Set set = fAssociations.keySet();
            Object[] arrStrings = set.toArray();
            int i = 0;
            while (i < fAssociations.size()) {
                int numF = (Integer)fAssociations.get(arrStrings[i]);
                rf.writeInt(numF);
                ((FeatureKey)arrStrings[i]).save(rf);
                ++i;
            }
            rf.close();
            ambClasses.save(String.valueOf(filename) + ".acls");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveAssociations(String filename) {
        try {
            OutDataStreamFile rf = new OutDataStreamFile(filename);
            rf.writeInt(fAssociations.size());
            Set set = fAssociations.keySet();
            Object[] arrStrings = set.toArray();
            int i = 0;
            while (i < fAssociations.size()) {
                ((FeatureKey)arrStrings[i]).save(rf);
                ++i;
            }
            rf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HashMap readAssociations(String modelFilename) {
        try {
            HashMap<FeatureKey, Integer> fAssocs = new HashMap<FeatureKey, Integer>();
            String filename = String.valueOf(modelFilename) + ".assoc";
            InDataStreamFile rf = new InDataStreamFile(filename);
            int sizeAssoc = rf.readInt();
            int i = 0;
            while (i < sizeAssoc) {
                int numF = rf.readInt();
                FeatureKey fK = new FeatureKey();
                fK.read(rf);
                fAssocs.put(fK, new Integer(numF));
                ++i;
            }
            rf.close();
            return fAssocs;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void release_mem() {
        dict.release();
        pairs.release();
        tHistories.release();
        tFeature.release();
        fAssociations.clear();
    }

    public static void save_after(String filename) {
        try {
            prob.save(String.valueOf(filename) + ".prob");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean read(String filename) throws Exception {
        InDataStreamFile rf = null;
        rf = new InDataStreamFile(filename);
        xSize = rf.readInt();
        ySize = rf.readInt();
        dict.read(String.valueOf(filename) + ".dict");
        tags.read(String.valueOf(filename) + ".tags");
        GlobalHolder.readExtractors(String.valueOf(filename) + ".ex");
        dict.setAmbClasses();
        int[] numFA = new int[extractors.getSize() + extractorsRare.getSize()];
        int sizeAssoc = rf.readInt();
        int i = 0;
        while (i < sizeAssoc) {
            int numF = rf.readInt();
            FeatureKey fK = new FeatureKey();
            fK.read(rf);
            int n = fK.num;
            numFA[n] = numFA[n] + 1;
            fAssociations.put(fK, new Integer(numF));
            ++i;
        }
        prob = new LambdaSolveTagger(String.valueOf(filename) + ".prob");
        rf.close();
        return true;
    }

    public static void read_prev(String filename) {
        try {
            InDataStreamFile rf = new InDataStreamFile(filename);
            xSize = rf.readInt();
            ySize = rf.readInt();
            dict.read(String.valueOf(filename) + ".dict");
            tags.read(String.valueOf(filename) + ".tags");
            pairs.read(String.valueOf(filename) + ".pairs");
            Features feats = new Features();
            TaggerExperiments d = new TaggerExperiments();
            d.read(String.valueOf(filename) + ".dat");
            domain = d;
            Problem p = new Problem(d, feats);
            prob = new LambdaSolveTagger(p, 1.0E-4, 1.0E-5);
            int sizeAssoc = rf.readInt();
            int i = 0;
            while (i < sizeAssoc) {
                int numF = rf.readInt();
                int len = rf.readInt();
                byte[] buff = new byte[len];
                rf.read(buff);
                fAssociations.put(new String(buff), new Integer(numF));
                ++i;
            }
            rf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isRare(String word) {
        return dict.sum(word) < rareThreshold;
    }
}

