/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.tagger.maxent.TestSentence;

public class FeatureKey {
    int num;
    String val;
    String tag;

    public FeatureKey() {
    }

    public FeatureKey(int num, String val, String tag) {
        this.num = num;
        this.val = val;
        this.tag = tag;
    }

    public void set(int num, String val, String tag) {
        this.num = num;
        this.val = val;
        this.tag = tag;
    }

    public String toString() {
        return String.valueOf(this.num) + " " + this.val + " " + this.tag;
    }

    public void save(OutDataStreamFile f) {
        try {
            f.writeInt(this.num);
            f.writeUTF(this.val);
            f.writeUTF(this.tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(InDataStreamFile inf) {
        try {
            this.num = inf.readInt();
            this.val = inf.readUTF();
            this.tag = inf.readUTF();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    String cleanup(String val) {
        int index = val.indexOf("!");
        if (index > -1) {
            String first = val.substring(0, index);
            String last = val.substring(index + 1);
            System.out.println("in " + first + " " + last);
            first = TestSentence.toNice(first);
            last = TestSentence.toNice(last);
            System.out.println("out " + first + " " + last);
            return String.valueOf(first) + "!" + last;
        }
        return val;
    }

    public int hashCode() {
        if (this.val == null) {
            return 5 ^ this.tag.hashCode();
        }
        return this.num << 16 ^ this.val.hashCode() << 5 ^ this.tag.hashCode();
    }

    public boolean equals(Object o) {
        FeatureKey f1 = (FeatureKey)o;
        return this.num == f1.num && this.tag.equals(f1.tag) && this.val.equals(f1.val);
    }
}

