/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.InDataStreamFile;
import edu.stanford.nlp.io.OutDataStreamFile;
import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.History;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class Extractors
implements Serializable {
    private Extractor[] v;
    private static final long serialVersionUID = -4777107742414749890L;

    public Extractors() {
    }

    public Extractors(int length) {
        this.v = new Extractor[length];
    }

    public void init(Extractor[] extrs) {
        this.v = new Extractor[extrs.length];
        int i = 0;
        while (i < extrs.length) {
            this.v[i] = extrs[i];
            ++i;
        }
    }

    public String extract(int i, History h) {
        return this.v[i].extract(h);
    }

    public void set(Extractor e, int index) {
        this.v[index] = e;
    }

    public boolean equals(History h, History h1) {
        int i = 0;
        while (i < this.v.length) {
            if (!this.v[i].extract(h).equals(this.v[i].extract(h1))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int leftContext() {
        int max = 0;
        int j = 0;
        while (j < this.v.length) {
            int lf = this.v[j].leftContext();
            if (lf > max) {
                max = lf;
            }
            ++j;
        }
        return max;
    }

    public int rightContext() {
        int max = 0;
        int j = 0;
        while (j < this.v.length) {
            int lf = this.v[j].rightContext();
            if (lf > max) {
                max = lf;
            }
            ++j;
        }
        return max;
    }

    public int getSize() {
        return this.v.length;
    }

    public void save(String filename) {
        try {
            OutDataStreamFile rf = new OutDataStreamFile(filename);
            rf.writeInt(this.v.length);
            int i = 0;
            while (i < this.v.length) {
                rf.writeBytes(this.v[i].toString());
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(String filename) {
        try {
            InDataStreamFile rf = new InDataStreamFile(filename);
            int len = rf.readInt();
            this.v = new Extractor[len];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    Extractor get(int index) {
        return this.v[index];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Extractors[");
        int i = 0;
        while (i < this.v.length) {
            sb.append(this.v[i].toString());
            if (i < this.v.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(args[0]));
            Extractors extrs = (Extractors)in.readObject();
            Extractors extrsRare = (Extractors)in.readObject();
            in.close();
            System.out.println("All words:  " + extrs);
            System.out.println("Rare words: " + extrsRare);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

