/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.ExtractorFrames;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.TestSentence;
import java.util.HashMap;
import java.util.HashSet;

public class ExtractorParticlesChris
extends Extractor {
    private static final String partTag = TestSentence.toSt("RP");
    private static final String inTag = TestSentence.toSt("IN");
    private static final String rbTag = TestSentence.toSt("RB");
    private final int bound;
    private HashSet s = new HashSet();
    private HashMap forms = new HashMap();
    private static final long serialVersionUID = 2631506606864457451L;

    public boolean Precondition(String tag) {
        return tag.equals(partTag) || tag.equals(inTag) || tag.equals(rbTag);
    }

    public ExtractorParticlesChris() {
        this(3);
    }

    public ExtractorParticlesChris(int bound) {
        this.bound = bound;
        this.s.add("back:down");
        this.s.add("back:up");
        this.s.add("backed:down");
        this.s.add("backed:up");
        this.s.add("bail:out");
        this.s.add("blip:up");
        this.s.add("beef:up");
        this.s.add("bottle:up");
        this.s.add("bottom:out");
        this.s.add("break:down");
        this.s.add("break:out");
        this.s.add("break:up");
        this.s.add("bring:out");
        this.s.add("build:up");
        this.s.add("carry:out");
        this.s.add("carried:out");
        this.s.add("catch:up");
        this.s.add("caught:up");
        this.s.add("clean:up");
        this.s.add("cover:up");
        this.s.add("cut:off");
        this.s.add("draw:up");
        this.s.add("drew:up");
        this.s.add("drawn:up");
        this.s.add("drive:down");
        this.s.add("drove:down");
        this.s.add("driven:down");
        this.s.add("fend:off");
        this.s.add("fight:off");
        this.s.add("fought:off");
        this.s.add("figure:out");
        this.s.add("figured:out");
        this.s.add("give:up");
        this.s.add("gave:up");
        this.s.add("hold:up");
        this.s.add("held:up");
        this.s.add("keep:up");
        this.s.add("kept:up");
        this.s.add("knock:down");
        this.s.add("make:up");
        this.s.add("made:up");
        this.s.add("open:up");
        this.s.add("pay:off");
        this.s.add("pick:up");
        this.s.add("prop:up");
        this.s.add("put:up");
        this.s.add("rule:out");
        this.s.add("ruled:out");
        this.s.add("seek:out");
        this.s.add("sought:out");
        this.s.add("sell:off");
        this.s.add("sell:out");
        this.s.add("set:off");
        this.s.add("set:out");
        this.s.add("set:up");
        this.s.add("slow:down");
        this.s.add("snap:up");
        this.s.add("spin:off");
        this.s.add("tie:up");
        this.s.add("tied:up");
        this.s.add("touch:off");
        this.s.add("turn:off");
        this.s.add("turn:out");
        this.s.add("wipe:out");
        this.s.add("wiped:up");
        this.s.add("work:out");
        this.s.add("work:up");
        this.s.add("write:off");
        this.s.add("wrote:off");
        this.s.add("written:off");
        this.forms.put("drew", "draw");
        this.forms.put("drawn", "draw");
        this.forms.put("drove", "drive");
        this.forms.put("driven", "drive");
        this.forms.put("fought", "fight");
        this.forms.put("figured", "figure");
        this.forms.put("gave", "give");
        this.forms.put("given", "give");
        this.forms.put("held", "hold");
        this.forms.put("kept", "keep");
        this.forms.put("made", "make");
        this.forms.put("paid", "pay");
        this.forms.put("bottled", "bottle");
        this.forms.put("broke", "break");
        this.forms.put("broken", "break");
        this.forms.put("brought", "bring");
        this.forms.put("built", "build");
        this.forms.put("carried", "carry");
        this.forms.put("caught", "catch");
        this.forms.put("ruled", "rule");
        this.forms.put("sought", "seek");
        this.forms.put("tied", "tie");
        this.forms.put("wiped", "wipe");
        this.forms.put("wrote", "write");
        this.forms.put("written", "write");
        this.forms.put("sold", "sell");
    }

    String getMainForm(String verb1) {
        String verb = TestSentence.toNice(verb1);
        if (this.forms.containsKey(verb)) {
            return (String)this.forms.get(verb);
        }
        if (verb.endsWith("ed") || verb.endsWith("en")) {
            return verb.substring(0, verb.length() - 2);
        }
        return verb;
    }

    String extract(History h) {
        String cword = ExtractorFrames.cWord.extract(h);
        if (GlobalHolder.dict.getCount(cword, partTag) < 1) {
            return "0";
        }
        String lastverb = ExtractorParticlesChris.extractLV(h, this.bound);
        if (lastverb.startsWith("NA")) {
            return "3";
        }
        if (this.isPartikleTakingVerb(lastverb = this.getMainForm(lastverb), cword = TestSentence.toNice(cword))) {
            return "1";
        }
        return "2";
    }

    static String extractLV(History h, int bound) {
        int start = h.start;
        String lastverb = TestSentence.toSt("NA");
        int current = h.current;
        int index = current - 1;
        while (index >= start && index >= current - bound) {
            String tag = GlobalHolder.pairs.get(index, true);
            if (tag.startsWith("VB")) {
                lastverb = GlobalHolder.pairs.get(index, false);
                break;
            }
            if (tag.startsWith(",")) break;
            --index;
        }
        return lastverb;
    }

    public boolean isPartikleTakingVerb(String lastverb, String cWord) {
        String together = String.valueOf(lastverb) + ":" + cWord;
        return this.s.contains(together);
    }
}

