/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.ExtractorFrames;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.TestSentence;

public class ExtractorLastVerb
extends Extractor {
    private static final String partTag = TestSentence.toSt("RP");
    private static final String inTag = TestSentence.toSt("IN");
    private static final String rbTag = TestSentence.toSt("RB");
    private static final String rareVerb = TestSentence.toSt("rareverbed");
    private final int bound;
    private static final long serialVersionUID = -16619310062224383L;

    public ExtractorLastVerb() {
        this(8);
    }

    public ExtractorLastVerb(int bound) {
        this.bound = bound;
    }

    public boolean Precondition(String tag) {
        return tag.equals(partTag) || tag.equals(inTag) || tag.equals(rbTag);
    }

    String extract(History h) {
        String cword = ExtractorFrames.cWord.extract(h);
        int allCount = GlobalHolder.dict.sum(cword);
        int rpCount = GlobalHolder.dict.getCount(cword, "RP");
        int rbCount = GlobalHolder.dict.getCount(cword, "RB");
        int inCount = GlobalHolder.dict.getCount(cword, "IN");
        if (allCount == 0 || allCount > 0 && rpCount + rbCount + inCount <= allCount / 100) {
            return "0";
        }
        String lastverb = this.extractLV(h, this.bound);
        if (lastverb.startsWith("NA")) {
            return "2";
        }
        if (GlobalHolder.dict.sum(lastverb) < 2) {
            return String.valueOf(rareVerb) + "|" + cword;
        }
        return String.valueOf(lastverb) + "|" + cword;
    }

    String extractLV(History h) {
        int start = h.start;
        String lastverb = TestSentence.toSt("NA");
        int current = h.current;
        int index = current - 1;
        while (index >= start) {
            String tag = GlobalHolder.pairs.get(index, true);
            if (tag.startsWith("VB")) {
                lastverb = GlobalHolder.pairs.get(index, false);
                break;
            }
            if (tag.startsWith(",")) break;
            --index;
        }
        return lastverb;
    }

    String extractLV(History h, int bound) {
        int start = h.start;
        String lastverb = TestSentence.toSt("NA");
        int current = h.current;
        int index = current - 1;
        while (index >= start && index >= current - bound) {
            String tag = GlobalHolder.pairs.get(index, true);
            if (tag.startsWith("VB")) {
                lastverb = GlobalHolder.pairs.get(index, false);
                break;
            }
            if (tag.startsWith(",")) break;
            --index;
        }
        return lastverb;
    }
}

