/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.ASBCPreDetector;
import edu.stanford.nlp.tagger.maxent.ASBCSufDetector;
import edu.stanford.nlp.tagger.maxent.ASBCunkDetector;
import edu.stanford.nlp.tagger.maxent.CTBunkDictDetector;
import edu.stanford.nlp.tagger.maxent.CompanyNameDetector;
import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.ExtractorAllCap;
import edu.stanford.nlp.tagger.maxent.ExtractorAllCapitalized;
import edu.stanford.nlp.tagger.maxent.ExtractorCNumber;
import edu.stanford.nlp.tagger.maxent.ExtractorCWordPref;
import edu.stanford.nlp.tagger.maxent.ExtractorCWordSuff;
import edu.stanford.nlp.tagger.maxent.ExtractorCapC;
import edu.stanford.nlp.tagger.maxent.ExtractorCapDistLC;
import edu.stanford.nlp.tagger.maxent.ExtractorCapLCSeen;
import edu.stanford.nlp.tagger.maxent.ExtractorDash;
import edu.stanford.nlp.tagger.maxent.ExtractorFrames;
import edu.stanford.nlp.tagger.maxent.ExtractorLetterDigitDash;
import edu.stanford.nlp.tagger.maxent.ExtractorMidSentenceCap;
import edu.stanford.nlp.tagger.maxent.ExtractorMidSentenceCapC;
import edu.stanford.nlp.tagger.maxent.ExtractorMorpho;
import edu.stanford.nlp.tagger.maxent.ExtractorStartSentenceCap;
import edu.stanford.nlp.tagger.maxent.ExtractorUCase;
import edu.stanford.nlp.tagger.maxent.ExtractorUpperDigitDash;
import edu.stanford.nlp.tagger.maxent.ExtractorsConjunction;
import edu.stanford.nlp.tagger.maxent.GlobalHolder;
import edu.stanford.nlp.tagger.maxent.PluralAcronymDetector;
import edu.stanford.nlp.tagger.maxent.ctbPreDetector;
import edu.stanford.nlp.tagger.maxent.ctbSufDetector;
import java.util.ArrayList;

public class ExtractorFramesRare {
    public static Extractor cWordSuff1 = new ExtractorCWordSuff(1);
    public static Extractor cWordSuff2 = new ExtractorCWordSuff(2);
    public static Extractor cWordSuff3 = new ExtractorCWordSuff(3);
    public static Extractor cWordSuff4 = new ExtractorCWordSuff(4);
    public static Extractor cWordPref1 = new ExtractorCWordPref(1);
    public static Extractor cWordPref2 = new ExtractorCWordPref(2);
    public static Extractor cWordPref3 = new ExtractorCWordPref(3);
    public static Extractor cWordPref4 = new ExtractorCWordPref(4);
    public static Extractor cWordUppCase = new ExtractorUCase();
    public static Extractor cWordNumber = new ExtractorCNumber();
    public static Extractor cWordDash = new ExtractorDash();
    public static Extractor cWordStartUCase = new ExtractorStartSentenceCap();
    public static Extractor cWordMidUCase = new ExtractorMidSentenceCapC();
    public static Extractor cUCaseLCase = new ExtractorCapC();
    public static Extractor cMidSentence = new ExtractorMidSentenceCap();
    public static Extractor cAllCap = new ExtractorAllCap();
    public static Extractor cAllCapitalized = new ExtractorAllCapitalized();
    public static Extractor cCompany = new CompanyNameDetector();
    public static Extractor cPluralAcronym = new PluralAcronymDetector();
    public static Extractor cLetterDigitDash = new ExtractorLetterDigitDash();
    public static Extractor cUpperDigitDash = new ExtractorUpperDigitDash();
    public static Extractor cCapDist = new ExtractorCapDistLC();
    public static Extractor[] eFrames = new Extractor[]{cWordUppCase, cWordNumber, cWordDash, cWordSuff1, cWordSuff2, cWordSuff3, cWordSuff4, cAllCap, cMidSentence, cWordStartUCase, cWordMidUCase, cWordPref1, cWordPref2, cWordPref3, cWordPref4, new ExtractorCWordPref(5), new ExtractorCWordPref(6), new ExtractorCWordPref(7), new ExtractorCWordPref(8), new ExtractorCWordPref(9), new ExtractorCWordPref(10), new ExtractorCWordSuff(5), new ExtractorCWordSuff(6), new ExtractorCWordSuff(7), new ExtractorCWordSuff(8), new ExtractorCWordSuff(9), new ExtractorCWordSuff(10), cLetterDigitDash, cCompany, cAllCapitalized, cUpperDigitDash};
    public static int size = eFrames.length;
    public static int[] countFeats;
    public static int[] nums;
    public static String zeroSt;

    static {
        zeroSt = "0";
    }

    public static void addFeatures() {
        ExtractorFramesRare.addConjunctions();
        size = eFrames.length;
        GlobalHolder.init();
    }

    public static void addConjunctions() {
        Extractor[] newW = new Extractor[]{new ExtractorsConjunction(cWordUppCase, cWordSuff1), new ExtractorsConjunction(cWordUppCase, cWordSuff2), new ExtractorsConjunction(cWordUppCase, cWordSuff3), new ExtractorsConjunction(cWordUppCase, cWordSuff4), new ExtractorsConjunction(cAllCap, cWordSuff1), new ExtractorsConjunction(cAllCap, cWordSuff2), new ExtractorsConjunction(cAllCap, cWordSuff3), new ExtractorsConjunction(cAllCap, cWordSuff4), new ExtractorsConjunction(cMidSentence, cWordSuff1), new ExtractorsConjunction(cMidSentence, cWordSuff2), new ExtractorsConjunction(cMidSentence, cWordSuff3), new ExtractorsConjunction(cMidSentence, cWordSuff4), new ExtractorsConjunction(cWordStartUCase, cWordSuff1), new ExtractorsConjunction(cWordStartUCase, cWordSuff2), new ExtractorsConjunction(cWordStartUCase, cWordSuff3), new ExtractorsConjunction(cWordStartUCase, cWordSuff4), new ExtractorsConjunction(cWordMidUCase, cWordSuff1), new ExtractorsConjunction(cWordMidUCase, cWordSuff2), new ExtractorsConjunction(cWordMidUCase, cWordSuff3), new ExtractorsConjunction(cWordMidUCase, cWordSuff4), new ExtractorsConjunction(cCapDist, cWordSuff1), new ExtractorsConjunction(cCapDist, cWordSuff2), new ExtractorsConjunction(cCapDist, cWordSuff3), new ExtractorsConjunction(cCapDist, cWordSuff4)};
        Extractor[] eFramesNew = new Extractor[eFrames.length + newW.length];
        int i = 0;
        while (i < eFrames.length) {
            eFramesNew[i] = eFrames[i];
            ++i;
        }
        int j = 0;
        while (j < newW.length) {
            eFramesNew[ExtractorFramesRare.eFrames.length + j] = newW[j];
            ++j;
        }
        eFrames = eFramesNew;
    }

    public static void addLCTagFeatures() {
        Extractor[] newE = new Extractor[GlobalHolder.tags.getSize()];
        int i = 0;
        while (i < GlobalHolder.tags.getSize()) {
            String tag = GlobalHolder.tags.getTag(i);
            newE[i] = new ExtractorCapLCSeen(tag);
            ++i;
        }
        Extractor[] eFramesNew = new Extractor[eFrames.length + newE.length];
        int i2 = 0;
        while (i2 < eFrames.length) {
            eFramesNew[i2] = eFrames[i2];
            ++i2;
        }
        int j = 0;
        while (j < newE.length) {
            eFramesNew[ExtractorFramesRare.eFrames.length + j] = newE[j];
            ++j;
        }
        eFrames = eFramesNew;
        GlobalHolder.init();
    }

    public ExtractorFramesRare() {
        ExtractorMorpho extr;
        System.out.println("calling init for extractorframesrare ");
        System.exit(0);
        ArrayList<ExtractorMorpho> v = new ArrayList<ExtractorMorpho>();
        GlobalHolder.ySize = GlobalHolder.tags.getSize();
        int i = 1;
        while (i < 5) {
            int y = 0;
            while (y < GlobalHolder.tags.getSize()) {
                if (!GlobalHolder.tags.isClosed(GlobalHolder.tags.getTag(y))) {
                    extr = new ExtractorMorpho(i, y);
                    v.add(extr);
                }
                ++y;
            }
            ++i;
        }
        int y = 0;
        while (y < GlobalHolder.ySize) {
            int y1 = 0;
            while (y1 < GlobalHolder.ySize) {
                if (!GlobalHolder.tags.isClosed(GlobalHolder.tags.getTag(y)) && !GlobalHolder.tags.isClosed(GlobalHolder.tags.getTag(y))) {
                    extr = new ExtractorMorpho(5, y, y1);
                    v.add(extr);
                }
                ++y1;
            }
            ++y;
        }
        Extractor[] eFramestemp = new Extractor[size + v.size()];
        int i2 = 0;
        while (i2 < size) {
            eFramestemp[i2] = eFrames[i2];
            ++i2;
        }
        i2 = size;
        while (i2 < size + v.size()) {
            eFramestemp[i2] = (Extractor)v.get(i2 - size);
            ++i2;
        }
        eFrames = eFramestemp;
        countFeats = new int[ExtractorFrames.maxSize + (size += v.size())];
    }

    public static void clearEmpty() {
        System.out.println(" entering clear empty ");
        ArrayList<Extractor> v = new ArrayList<Extractor>();
        nums = new int[200];
        int counts = 0;
        int i = ExtractorFrames.maxSize;
        while (i < size + ExtractorFrames.maxSize) {
            if (countFeats[i] > 0) {
                v.add(eFrames[i - ExtractorFrames.maxSize]);
                ExtractorFramesRare.nums[counts++] = i;
            }
            ++i;
        }
        Extractor[] eFramestemp = new Extractor[v.size()];
        int i2 = 0;
        while (i2 < v.size()) {
            eFramestemp[i2] = (Extractor)v.get(i2);
            ++i2;
        }
        size = v.size();
        eFrames = eFramestemp;
    }

    public static void addSighanChineseFeatures() {
        int i = -2;
        while (i <= 2) {
            ExtractorFramesRare.addCTBprefeatures(i);
            ExtractorFramesRare.addCTBsuffeatures(i);
            ExtractorFramesRare.addCTBunkDictfeatures(i);
            ExtractorFramesRare.addASBCunkfeatures(i);
            ++i;
        }
    }

    public static void addCTBprefeatures(int n) {
        String[] tagsets = new String[]{"AD", "AS", "BA", "CC", "CD", "CS", "DEC", "DEG", "DER", "DEV", "DT", "ETC", "FW", "IJ", "JJ", "LB", "LC", "M", "MSP", "NN", "NP", "NR", "NT", "OD", "P", "PN", "PU", "SB", "SP", "VA", "VC", "VE", "VV"};
        Extractor[] newW = new Extractor[tagsets.length];
        int k = 0;
        while (k < tagsets.length) {
            newW[k] = new ctbPreDetector(tagsets[k], n);
            ++k;
        }
        Extractor[] eFramesNew = new Extractor[eFrames.length + newW.length];
        int i = 0;
        while (i < eFrames.length) {
            eFramesNew[i] = eFrames[i];
            ++i;
        }
        int j = 0;
        while (j < newW.length) {
            eFramesNew[ExtractorFramesRare.eFrames.length + j] = newW[j];
            ++j;
        }
        eFrames = eFramesNew;
    }

    public static void addCTBsuffeatures(int n) {
        String[] tagsets = new String[]{"AD", "AS", "BA", "CC", "CD", "CS", "DEC", "DEG", "DER", "DEV", "DT", "ETC", "FW", "IJ", "JJ", "LB", "LC", "M", "MSP", "NN", "NP", "NR", "NT", "OD", "P", "PN", "PU", "SB", "SP", "VA", "VC", "VE", "VV"};
        Extractor[] newW = new Extractor[tagsets.length];
        int k = 0;
        while (k < tagsets.length) {
            newW[k] = new ctbSufDetector(tagsets[k], n);
            ++k;
        }
        Extractor[] eFramesNew = new Extractor[eFrames.length + newW.length];
        int i = 0;
        while (i < eFrames.length) {
            eFramesNew[i] = eFrames[i];
            ++i;
        }
        int j = 0;
        while (j < newW.length) {
            eFramesNew[ExtractorFramesRare.eFrames.length + j] = newW[j];
            ++j;
        }
        eFrames = eFramesNew;
    }

    public static void addASBCprefeatures(int n) {
        String[] tagsets = new String[]{"A", "Caa", "Cab", "Cba", "Cbb", "D", "DE", "DK", "Da", "Dd", "De", "Des", "Dfa", "Dfb", "Di", "Dk", "FW", "I", " Na", "Nb", " Nc", "Ncb", "Ncd", " Nd", "Neaq", "Nep", "Neqa", "Neqb", "Nes", "Neu", "Nf", "Ng", "Nh", "P", "PU", "SHI", "T", "VA", "VAC", "VB", "VC", "VCL", "VD", "VE", "VF", "VG", "VH", "VHC", "VI", "VJ", "VK", "VL", "V_2"};
        Extractor[] newW = new Extractor[tagsets.length];
        int k = 0;
        while (k < tagsets.length) {
            newW[k] = new ASBCPreDetector(tagsets[k], n);
            ++k;
        }
        Extractor[] eFramesNew = new Extractor[eFrames.length + newW.length];
        int i = 0;
        while (i < eFrames.length) {
            eFramesNew[i] = eFrames[i];
            ++i;
        }
        int j = 0;
        while (j < newW.length) {
            eFramesNew[ExtractorFramesRare.eFrames.length + j] = newW[j];
            ++j;
        }
        eFrames = eFramesNew;
    }

    public static void addASBCsuffeatures(int n) {
        String[] tagsets = new String[]{"A", "Caa", "Cab", "Cba", "Cbb", "D", "DE", "DK", "Da", "Dd", "De", "Des", "Dfa", "Dfb", "Di", "Dk", "FW", "I", " Na", "Nb", " Nc", "Ncb", "Ncd", " Nd", "Neaq", "Nep", "Neqa", "Neqb", "Nes", "Neu", "Nf", "Ng", "Nh", "P", "PU", "SHI", "T", "VA", "VAC", "VB", "VC", "VCL", "VD", "VE", "VF", "VG", "VH", "VHC", "VI", "VJ", "VK", "VL", "V_2"};
        Extractor[] newW = new Extractor[tagsets.length];
        int k = 0;
        while (k < tagsets.length) {
            newW[k] = new ASBCSufDetector(tagsets[k], n);
            ++k;
        }
        Extractor[] eFramesNew = new Extractor[eFrames.length + newW.length];
        int i = 0;
        while (i < eFrames.length) {
            eFramesNew[i] = eFrames[i];
            ++i;
        }
        int j = 0;
        while (j < newW.length) {
            eFramesNew[ExtractorFramesRare.eFrames.length + j] = newW[j];
            ++j;
        }
        eFrames = eFramesNew;
    }

    public static void addASBCunkfeatures(int n) {
        String[] tagsets = new String[]{"A", "Caa", "Cab", "Cba", "Cbb", "D", "DE", "DK", "Da", "Dd", "De", "Des", "Dfa", "Dfb", "Di", "Dk", "FW", "I", " Na", "Nb", " Nc", "Ncb", "Ncd", " Nd", "Neaq", "Nep", "Neqa", "Neqb", "Nes", "Neu", "Nf", "Ng", "Nh", "P", "PU", "SHI", "T", "VA", "VAC", "VB", "VC", "VCL", "VD", "VE", "VF", "VG", "VH", "VHC", "VI", "VJ", "VK", "VL", "V_2"};
        Extractor[] newW = new Extractor[tagsets.length];
        int k = 0;
        while (k < tagsets.length) {
            newW[k] = new ASBCunkDetector(tagsets[k], n);
            ++k;
        }
        Extractor[] eFramesNew = new Extractor[eFrames.length + newW.length];
        int i = 0;
        while (i < eFrames.length) {
            eFramesNew[i] = eFrames[i];
            ++i;
        }
        int j = 0;
        while (j < newW.length) {
            eFramesNew[ExtractorFramesRare.eFrames.length + j] = newW[j];
            ++j;
        }
        eFrames = eFramesNew;
    }

    public static void addCTBunkDictfeatures(int n) {
        String[] tagsets = new String[]{"A", "Caa", "Cab", "Cba", "Cbb", "D", "DE", "DK", "Da", "Dd", "De", "Des", "Dfa", "Dfb", "Di", "Dk", "FW", "I", " Na", "Nb", " Nc", "Ncb", "Ncd", " Nd", "Neaq", "Nep", "Neqa", "Neqb", "Nes", "Neu", "Nf", "Ng", "Nh", "P", "PU", "SHI", "T", "VA", "VAC", "VB", "VC", "VCL", "VD", "VE", "VF", "VG", "VH", "VHC", "VI", "VJ", "VK", "VL", "V_2"};
        Extractor[] newW = new Extractor[tagsets.length];
        int k = 0;
        while (k < tagsets.length) {
            newW[k] = new CTBunkDictDetector(tagsets[k], n);
            ++k;
        }
        Extractor[] eFramesNew = new Extractor[eFrames.length + newW.length];
        int i = 0;
        while (i < eFrames.length) {
            eFramesNew[i] = eFrames[i];
            ++i;
        }
        int j = 0;
        while (j < newW.length) {
            eFramesNew[ExtractorFramesRare.eFrames.length + j] = newW[j];
            ++j;
        }
        eFrames = eFramesNew;
    }
}

