/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.MapFactory;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoDimensionalCounter<K1, K2> {
    private Map<K1, Counter<K2>> map;
    private double total;
    private MapFactory mf;

    public Counter<K2> getCounter(K1 o) {
        Counter<Object> c = this.map.get(o);
        if (c == null) {
            c = new Counter(this.mf);
            this.map.put(o, c);
        }
        return c;
    }

    public int size() {
        int result = 0;
        for (K1 o : this.firstKeySet()) {
            Counter<K2> c = this.map.get(o);
            result += c.size();
        }
        return result;
    }

    public boolean containsKey(K1 o1, K2 o2) {
        if (!this.map.containsKey(o1)) {
            return false;
        }
        Counter<K2> c = this.map.get(o1);
        return c.containsKey(o2);
    }

    public void incrementCount(K1 o1, K2 o2) {
        this.incrementCount(o1, o2, 1.0);
    }

    public void incrementCount(K1 o1, K2 o2, double count) {
        Counter<K2> c = this.getCounter(o1);
        c.incrementCount(o2, count);
        this.total += count;
    }

    public void setCount(K1 o1, K2 o2, double count) {
        Counter<K2> c = this.getCounter(o1);
        double oldCount = this.getCount(o1, o2);
        this.total -= oldCount;
        c.setCount(o2, count);
        this.total += count;
    }

    public double getCount(K1 o1, K2 o2) {
        Counter<K2> c = this.getCounter(o1);
        return c.getCount(o2);
    }

    public double totalCount() {
        return this.total;
    }

    public double totalCount(K1 k1) {
        Counter<K2> c = this.getCounter(k1);
        return c.totalCount();
    }

    public Set<K1> firstKeySet() {
        return this.map.keySet();
    }

    public Counter<K2> setCounter(K1 o, Counter<K2> c) {
        Counter<K2> old = this.getCounter(o);
        this.total -= old.totalCount();
        this.map.put(o, c);
        this.total += c.totalCount();
        return old;
    }

    public static TwoDimensionalCounter reverseIndexOrder(TwoDimensionalCounter cc) {
        TwoDimensionalCounter result = new TwoDimensionalCounter(cc.mf);
        for (Object key1 : cc.firstKeySet()) {
            Counter c = cc.getCounter(key1);
            for (Object key2 : c.keySet()) {
                double count = c.getCount(key2);
                result.setCount(key2, key1, count);
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("{");
        Iterator<K1> iter1 = this.firstKeySet().iterator();
        while (iter1.hasNext()) {
            K1 key1 = iter1.next();
            Counter<K2> c = this.getCounter(key1);
            buff.append(key1 + "=" + c);
            if (!iter1.hasNext()) continue;
            buff.append(", ");
        }
        buff.append("}");
        return buff.toString();
    }

    public String toDatFileString() {
        StringBuilder buff = new StringBuilder();
        for (K1 key1 : this.map.keySet()) {
            Counter<K2> c = this.getCounter(key1);
            for (K2 key2 : c.keySet()) {
                double score = c.getCount(key2);
                buff.append(key1 + " " + key2 + " " + score + "\n");
            }
        }
        return buff.toString();
    }

    public String toMatrixString(int cellSize) {
        ArrayList<K1> firstKeys = new ArrayList<K1>(this.firstKeySet());
        ArrayList<K2> secondKeys = new ArrayList<K2>(this.secondKeySet());
        double[][] counts = this.toMatrix(firstKeys, secondKeys);
        return ArrayMath.toString(counts, cellSize, firstKeys.toArray(), secondKeys.toArray(), (NumberFormat)new DecimalFormat(), true);
    }

    public double[][] toMatrix(List<K1> firstKeys, List<K2> secondKeys) {
        double[][] counts = new double[firstKeys.size()][secondKeys.size()];
        for (int i = 0; i < firstKeys.size(); ++i) {
            for (int j = 0; j < secondKeys.size(); ++j) {
                counts[i][j] = this.getCount(firstKeys.get(i), secondKeys.get(j));
            }
        }
        return counts;
    }

    public String toCSVString(NumberFormat nf) {
        ArrayList<K1> rowLabels = new ArrayList<K1>(this.firstKeySet());
        Collections.sort(rowLabels);
        ArrayList<K2> colLabels = new ArrayList<K2>(this.secondKeySet());
        Collections.sort(colLabels);
        StringBuilder b = new StringBuilder();
        String[] headerRow = new String[colLabels.size() + 1];
        headerRow[0] = "";
        for (int j = 0; j < colLabels.size(); ++j) {
            headerRow[j + 1] = colLabels.get(j).toString();
        }
        b.append(StringUtils.toCSVString(headerRow) + "\n");
        for (int i = 0; i < rowLabels.size(); ++i) {
            String[] row = new String[colLabels.size() + 1];
            Object rowLabel = rowLabels.get(i);
            row[0] = rowLabel.toString();
            for (int j = 0; j < colLabels.size(); ++j) {
                Object colLabel = colLabels.get(j);
                row[j + 1] = nf.format(this.getCount(rowLabel, colLabel));
            }
            b.append(StringUtils.toCSVString(row) + "\n");
        }
        return b.toString();
    }

    public Set<K2> secondKeySet() {
        HashSet<K2> result = new HashSet<K2>();
        for (K1 k1 : this.firstKeySet()) {
            for (K2 k2 : this.getCounter(k1).keySet()) {
                result.add(k2);
            }
        }
        return result;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Counter<Pair<K1, K2>> flatten() {
        Counter<Pair<K1, K2>> result = new Counter<Pair<K1, K2>>();
        for (K1 key1 : this.firstKeySet()) {
            Counter<K2> inner = this.getCounter(key1);
            for (K2 key2 : inner.keySet()) {
                result.setCount(new Pair<K1, K2>(key1, key2), inner.getCount(key2));
            }
        }
        return result;
    }

    public void addAll(TwoDimensionalCounter<K1, K2> c) {
        for (K1 key : c.firstKeySet()) {
            Counter<K2> inner = c.getCounter(key);
            Counter<K2> myInner = this.getCounter(key);
            myInner.addAll(inner);
            this.total += inner.totalCount();
        }
    }

    public void subtractAll(TwoDimensionalCounter<K1, K2> c, boolean removeKeys) {
        for (K1 key : c.firstKeySet()) {
            Counter<K2> inner = c.getCounter(key);
            Counter<K2> myInner = this.getCounter(key);
            myInner.subtractAll(inner, removeKeys);
            this.total -= inner.totalCount();
        }
    }

    public MapFactory getMapFactory() {
        return this.mf;
    }

    public TwoDimensionalCounter() {
        this(MapFactory.HASH_MAP_FACTORY);
    }

    public TwoDimensionalCounter(MapFactory factory) {
        this.mf = factory;
        this.map = this.mf.newMap();
        this.total = 0.0;
    }

    public static void main(String[] args) {
        TwoDimensionalCounter<String, String> cc = new TwoDimensionalCounter<String, String>();
        cc.setCount("a", "c", 1.0);
        cc.setCount("b", "c", 1.0);
        cc.setCount("a", "d", 1.0);
        cc.setCount("a", "d", -1.0);
        cc.setCount("b", "d", 1.0);
        System.out.println(cc);
        cc.incrementCount("b", "d", 1.0);
        System.out.println(cc);
        TwoDimensionalCounter cc2 = TwoDimensionalCounter.reverseIndexOrder(cc);
        System.out.println(cc2);
    }
}

