/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.GenericCounter;
import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.util.BinaryHeapPriorityQueue;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.PriorityQueue;
import edu.stanford.nlp.util.Sets;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Counters<E> {
    public static <E> Counter<E> union(GenericCounter<E> c1, GenericCounter<E> c2) {
        Counter<E> result = new Counter<E>();
        result.addAll(c1);
        result.addAll(c2);
        return result;
    }

    public static <E> Counter<E> intersection(GenericCounter<E> c1, GenericCounter<E> c2) {
        Counter result = new Counter();
        for (Object key : Sets.union(c1.keySet(), c2.keySet())) {
            double count2;
            double count1 = c1.getCount(key);
            double d = count1 < (count2 = c2.getCount(key)) ? count1 : count2;
            double minCount = d;
            if (!(minCount > 0.0)) continue;
            result.setCount(key, minCount);
        }
        return result;
    }

    public static <E> double jaccardCoefficient(GenericCounter<E> c1, GenericCounter<E> c2) {
        double minCount = 0.0;
        double maxCount = 0.0;
        for (Object key : Sets.union(c1.keySet(), c2.keySet())) {
            double count2;
            double count1 = c1.getCount(key);
            minCount += count1 < (count2 = c2.getCount(key)) ? count1 : count2;
            maxCount += count1 > count2 ? count1 : count2;
        }
        return minCount / maxCount;
    }

    public static <E> Counter<E> product(GenericCounter<E> c1, GenericCounter<E> c2) {
        Counter result = new Counter();
        for (Object key : Sets.intersection(c1.keySet(), c2.keySet())) {
            result.setCount(key, c1.getCount(key) * c2.getCount(key));
        }
        return result;
    }

    public static <E> double dotProduct(GenericCounter<E> c1, GenericCounter<E> c2) {
        double dotProd = 0.0;
        for (E key : c1.keySet()) {
            double count2;
            double count1 = c1.getCount(key);
            if (count1 == 0.0 || (count2 = c2.getCount(key)) == 0.0) continue;
            dotProd += count1 * count2;
        }
        return dotProd;
    }

    public static <E> Counter<E> absoluteDifference(GenericCounter<E> c1, GenericCounter<E> c2) {
        Counter result = new Counter();
        for (Object key : Sets.union(c1.keySet(), c2.keySet())) {
            double newCount = Math.abs(c1.getCount(key) - c2.getCount(key));
            if (!(newCount > 0.0)) continue;
            result.setCount(key, newCount);
        }
        return result;
    }

    public static <E> Counter<E> division(GenericCounter<E> c1, GenericCounter<E> c2) {
        Counter result = new Counter();
        for (Object key : Sets.union(c1.keySet(), c2.keySet())) {
            result.setCount(key, c1.getCount(key) / c2.getCount(key));
        }
        return result;
    }

    public static <E> double entropy(GenericCounter<E> c) {
        double entropy = 0.0;
        double total = c.totalDoubleCount();
        for (E key : c.keySet()) {
            double count = c.getCount(key);
            if (count == 0.0) continue;
            entropy -= (count /= total) * (Math.log(count) / Math.log(2.0));
        }
        return entropy;
    }

    public static <E> double crossEntropy(GenericCounter<E> from, GenericCounter<E> to) {
        double tot2 = to.totalDoubleCount();
        double result = 0.0;
        double log2 = Math.log(2.0);
        for (E key : from.keySet()) {
            double count1 = from.getCount(key);
            if (count1 == 0.0) continue;
            double count2 = to.getCount(key);
            double logFract = Math.log(count2 / tot2);
            if (logFract == Double.NEGATIVE_INFINITY) {
                return Double.NEGATIVE_INFINITY;
            }
            result += count1 * (logFract / log2);
        }
        return result;
    }

    public static <E> double crossEntropy(GenericCounter<E> from, Counter<E> to) {
        double result = 0.0;
        double log2 = Math.log(2.0);
        for (E key : from.keySet()) {
            double count1 = from.getCount(key);
            if (count1 == 0.0) continue;
            double prob = to.getCount(key);
            double logFract = Math.log(prob);
            if (logFract == Double.NEGATIVE_INFINITY) {
                return Double.NEGATIVE_INFINITY;
            }
            double contribution = count1 * (logFract / log2);
            result += contribution;
        }
        return result;
    }

    public static <E> double klDivergence(GenericCounter<E> from, GenericCounter<E> to) {
        double result = 0.0;
        double tot = from.totalDoubleCount();
        double tot2 = to.totalDoubleCount();
        double log2 = Math.log(2.0);
        for (E key : from.keySet()) {
            double num = from.getCount(key);
            if (num == 0.0) continue;
            double num2 = to.getCount(key);
            double logFract = Math.log((num /= tot) / (num2 /= tot2));
            if (logFract == Double.NEGATIVE_INFINITY) {
                return Double.NEGATIVE_INFINITY;
            }
            result += num * (logFract / log2);
        }
        return result;
    }

    public static <E> double jensenShannonDivergence(GenericCounter<E> c1, GenericCounter<E> c2) {
        Counter<E> average = Counters.average(c1, c2);
        double kl1 = Counters.klDivergence(c1, average);
        double kl2 = Counters.klDivergence(c2, average);
        return (kl1 + kl2) / 2.0;
    }

    public static <E> double skewDivergence(GenericCounter<E> c1, GenericCounter<E> c2, double skew) {
        Counter<E> average = Counters.linearCombination(c2, skew, c1, 1.0 - skew);
        return Counters.klDivergence(c1, average);
    }

    public static <E> Counter<E> L2Normalize(GenericCounter<E> c) {
        double total = 0.0;
        for (E key : c.keySet()) {
            double count2 = c.getCount(key);
            if (count2 == 0.0) continue;
            total += count2 * count2;
        }
        return Counters.scale(c, 1.0 / Math.sqrt(total));
    }

    public static <E> double cosine(GenericCounter<E> c1, GenericCounter<E> c2) {
        double dotProd = 0.0;
        double lsq1 = 0.0;
        double lsq2 = 0.0;
        for (E key : c1.keySet()) {
            double count1 = c1.getCount(key);
            if (count1 == 0.0) continue;
            lsq1 += count1 * count1;
            double count2 = c2.getCount(key);
            if (count2 == 0.0) continue;
            dotProd += count1 * count2;
        }
        for (E key : c2.keySet()) {
            double count2 = c2.getCount(key);
            if (count2 == 0.0) continue;
            lsq2 += count2 * count2;
        }
        if (lsq1 != 0.0 && lsq2 != 0.0) {
            double denom = Math.sqrt(lsq1) * Math.sqrt(lsq2);
            return dotProd / denom;
        }
        return 0.0;
    }

    public static <E> Counter<E> average(GenericCounter<E> c1, GenericCounter<E> c2) {
        Counter average = new Counter();
        HashSet<E> allKeys = new HashSet<E>(c1.keySet());
        allKeys.addAll(c2.keySet());
        for (Object key : allKeys) {
            average.setCount(key, (c1.getCount(key) + c2.getCount(key)) * 0.5);
        }
        return average;
    }

    public static <E> Counter<E> linearCombination(GenericCounter<E> c1, double w1, GenericCounter<E> c2, double w2) {
        Counter<E> result = new Counter<E>();
        for (E o : c1.keySet()) {
            result.incrementCount(o, c1.getCount(o) * w1);
        }
        for (E o : c2.keySet()) {
            result.incrementCount(o, c2.getCount(o) * w2);
        }
        return result;
    }

    public static <E> Counter<E> perturbCounts(GenericCounter<E> c, Random random, double p) {
        Counter<E> result = new Counter<E>(c.getMapFactory());
        for (E key : c.keySet()) {
            double count = c.getCount(key);
            double noise = -Math.log(1.0 - random.nextDouble());
            double perturbedCount = count + noise * p;
            result.setCount(key, perturbedCount);
        }
        return result;
    }

    public static <E> Counter<E> createCounterFromList(List<E> l) {
        return Counters.createCounterFromCollection(l);
    }

    public static <E> Counter<E> createCounterFromCollection(Collection<E> l) {
        Counter<E> result = new Counter<E>();
        for (E o : l) {
            result.incrementCount(o);
        }
        return result;
    }

    public static <E> List<E> toSortedList(GenericCounter<E> c) {
        Comparator<E> comp = c.comparator();
        ArrayList<E> l = new ArrayList<E>(c.keySet());
        Collections.sort(l, comp);
        Collections.reverse(l);
        return l;
    }

    public static <E> PriorityQueue toPriorityQueue(GenericCounter<E> c) {
        BinaryHeapPriorityQueue<E> queue = new BinaryHeapPriorityQueue<E>();
        for (E key : c.keySet()) {
            double count = c.getCount(key);
            queue.add(key, count);
        }
        return queue;
    }

    public static <E> void printCounterComparison(GenericCounter<E> a, GenericCounter<E> b) {
        Counters.printCounterComparison(a, b, System.err);
    }

    public static <E> void printCounterComparison(GenericCounter<E> a, GenericCounter<E> b, PrintStream out2) {
        if (a.equals(b)) {
            out2.println("Counters are equal.");
            return;
        }
        for (E key : a.keySet()) {
            double bCount;
            double aCount = a.getCount(key);
            if (!(Math.abs(aCount - (bCount = b.getCount(key))) > 1.0E-5)) continue;
            out2.println("Counters differ on key " + key + "\t" + a.getCountAsString(key) + " vs. " + b.getCountAsString(key));
        }
        HashSet<E> rest = new HashSet<E>(b.keySet());
        rest.removeAll(a.keySet());
        for (Object key : rest) {
            double bCount;
            double aCount = a.getCount(key);
            if (!(Math.abs(aCount - (bCount = b.getCount(key))) > 1.0E-5)) continue;
            out2.println("Counters differ on key " + key + "\t" + a.getCountAsString(key) + " vs. " + b.getCountAsString(key));
        }
    }

    public static <E> Counter<Double> getCountCounts(GenericCounter<E> c) {
        Counter<Double> result = new Counter<Double>();
        for (E o : c.keySet()) {
            double count = c.getCount(o);
            result.incrementCount(new Double(count));
        }
        return result;
    }

    public static <E> Counter<E> scale(GenericCounter<E> c, double s) {
        Counter<E> scaled = new Counter<E>(c.getMapFactory());
        for (E key : c.keySet()) {
            scaled.setCount(key, c.getCount(key) * s);
        }
        return scaled;
    }

    public static <E> void printCounterSortedByKeys(GenericCounter<E> c) {
        ArrayList<E> keyList = new ArrayList<E>(c.keySet());
        Collections.sort(keyList);
        for (Object o : keyList) {
            System.out.println(o + ":" + c.getCountAsString(o));
        }
    }

    public static <E> Counter<E> loadCounter(String filename, Class c) throws Exception {
        Counter counter = new Counter();
        Counters.loadIntoCounter(filename, c, counter);
        return counter;
    }

    public static IntCounter loadIntCounter(String filename, Class c) throws Exception {
        IntCounter counter = new IntCounter();
        Counters.loadIntoCounter(filename, c, counter);
        return counter;
    }

    private static <E> void loadIntoCounter(String filename, Class c, GenericCounter<E> counter) throws Exception {
        Constructor m = c.getConstructor(Class.forName("java.lang.String"));
        Counter result = new Counter();
        BufferedReader in = new BufferedReader(new FileReader(filename));
        String line = in.readLine();
        while (line != null && line.length() > 0) {
            String[] fields = line.split("\\p{Space}+");
            Object o = m.newInstance(fields[0]);
            counter.setCount(o, fields[1]);
            line = in.readLine();
        }
        in.close();
    }

    public static <E> void saveCounter(GenericCounter<E> c, String filename) throws IOException {
        PrintWriter out2 = new PrintWriter(new FileWriter(filename));
        for (E key : c.keySet()) {
            out2.println(key + " " + c.getCountAsString(key));
        }
        out2.close();
    }

    public static List sortedKeys(Counter x) {
        ArrayList keys = new ArrayList(x.keySet());
        Collections.sort(keys, x.comparator(false));
        return keys;
    }

    public static String toBiggestValuesFirstString(Counter c) {
        return Counters.toPriorityQueue(c).toString();
    }

    public static String toBiggestValuesFirstString(Counter c, int k) {
        PriorityQueue pq = Counters.toPriorityQueue(c);
        BinaryHeapPriorityQueue largestK = new BinaryHeapPriorityQueue();
        while (largestK.size() < k && ((Iterator)((Object)pq)).hasNext()) {
            double firstScore = pq.getPriority(pq.getFirst());
            Object first = pq.removeFirst();
            largestK.changePriority(first, firstScore);
        }
        return ((Object)largestK).toString();
    }

    public static String toVerticalString(Counter c) {
        return Counters.toVerticalString(c, Integer.MAX_VALUE);
    }

    public static String toVerticalString(Counter c, int k) {
        PriorityQueue q = Counters.toPriorityQueue(c);
        List sortedKeys = q.toSortedList();
        StringBuffer sb = new StringBuffer();
        Iterator keyI = sortedKeys.iterator();
        for (int i = 0; keyI.hasNext() && i < k; ++i) {
            Object key = keyI.next();
            sb.append(key);
            sb.append("\t");
            sb.append(q.getPriority(key));
            if (!keyI.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static Object restrictedArgMax(Counter c, Collection restriction) {
        Object maxKey = null;
        double max = Double.NEGATIVE_INFINITY;
        for (Object key : restriction) {
            double count = c.getCount(key);
            if (!(count > max)) continue;
            max = count;
            maxKey = key;
        }
        return maxKey;
    }

    public static <T> Counter<T> toCounter(double[] counts, Index<T> index) {
        if (index.size() < counts.length) {
            throw new IllegalArgumentException("Index not large enough to name all the array elements!");
        }
        Counter<T> c = new Counter<T>();
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] == 0.0) continue;
            c.setCount(index.get(i), counts[i]);
        }
        return c;
    }

    public static <T1, T2> TwoDimensionalCounter<T1, T2> scale(TwoDimensionalCounter<T1, T2> c, double d) {
        TwoDimensionalCounter<T1, T2> result = new TwoDimensionalCounter<T1, T2>(c.getMapFactory());
        for (T1 key : c.firstKeySet()) {
            Counter<T2> ctr = c.getCounter(key);
            result.setCounter(key, Counters.scale(ctr, d));
        }
        return result;
    }

    public static <T> T sample(Counter<T> c, Random rand) {
        double r = rand.nextDouble();
        double total = 0.0;
        for (T t : c.keySet()) {
            double count = c.getCount(t);
            if (!((total += count) >= r)) continue;
            return t;
        }
        return c.keySet().iterator().next();
    }

    public static <T> Counter<T> pow(Counter<T> c, double temp) {
        Counter<T> d = new Counter<T>();
        for (T t : c.keySet()) {
            d.setCount(t, Math.pow(c.getCount(t), temp));
        }
        return d;
    }

    public static <T> Counter<T> exp(Counter<T> c) {
        Counter<T> d = new Counter<T>();
        for (T t : c.keySet()) {
            d.setCount(t, Math.exp(c.getCount(t)));
        }
        return d;
    }
}

