/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.process.AbstractTokenizer;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.process.WhitespaceLexer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhitespaceTokenizer
extends AbstractTokenizer<Word> {
    private WhitespaceLexer lexer;
    private final boolean eolIsSignificant;

    @Override
    protected Word getNext() {
        Word token = null;
        if (this.lexer == null) {
            return token;
        }
        try {
            token = this.lexer.next();
            while (token == WhitespaceLexer.crValue) {
                if (this.eolIsSignificant) {
                    return token;
                }
                token = this.lexer.next();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return token;
    }

    public WhitespaceTokenizer(Reader r) {
        this(r, false);
    }

    public WhitespaceTokenizer(Reader r, boolean eolIsSignificant) {
        this.eolIsSignificant = eolIsSignificant;
        if (r != null) {
            this.lexer = new WhitespaceLexer(r);
        }
    }

    private void setSource(Reader r) {
        this.lexer = new WhitespaceLexer(r);
    }

    public static TokenizerFactory factory() {
        return new WhitespaceTokenizerFactory(false);
    }

    public static TokenizerFactory factory(boolean eolIsSignificant) {
        return new WhitespaceTokenizerFactory(eolIsSignificant);
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.err.println("usage: java edu.stanford.nlp.process.WhitespaceTokenizer [-cr] filename");
            return;
        }
        WhitespaceTokenizer tokenizer = new WhitespaceTokenizer(new InputStreamReader((InputStream)new FileInputStream(args[args.length - 1]), "UTF-8"), args[0].equals("-cr"));
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), true);
        while (tokenizer.hasNext()) {
            Word w = (Word)tokenizer.next();
            if (w == WhitespaceLexer.crValue) {
                pw.println("***CR***");
                continue;
            }
            pw.println(w);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WhitespaceTokenizerFactory
    implements TokenizerFactory<Word> {
        private final boolean eolIsSignificant;

        public WhitespaceTokenizerFactory() {
            this(false);
        }

        public WhitespaceTokenizerFactory(boolean eolIsSignificant) {
            this.eolIsSignificant = eolIsSignificant;
        }

        @Override
        public Iterator<Word> getIterator(Reader r) {
            return this.getTokenizer(r);
        }

        @Override
        public Tokenizer<Word> getTokenizer(Reader r) {
            return new WhitespaceTokenizer(r, this.eolIsSignificant);
        }
    }
}

