/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.Rule;
import edu.stanford.nlp.util.Numberer;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;

public class UnaryRule
extends Rule
implements Serializable,
Comparable {
    public int child = -1;
    private static final char[] charsToEscape = new char[]{'\"'};
    private static final long serialVersionUID = 1L;

    public UnaryRule() {
    }

    public UnaryRule(String s, Numberer n) {
        String[] fields = StringUtils.splitOnCharWithQuoting(s, ' ', '\"', '\\');
        this.parent = n.number(fields[0]);
        this.child = n.number(fields[2]);
        this.score = Float.parseFloat(fields[3]);
    }

    public UnaryRule(int parent, int child, double score) {
        this.parent = parent;
        this.child = child;
        this.score = (float)score;
    }

    public boolean isUnary() {
        return true;
    }

    public int hashCode() {
        return this.parent << 16 ^ this.child;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnaryRule) {
            UnaryRule ur = (UnaryRule)o;
            if (this.parent == ur.parent && this.child == ur.child) {
                return true;
            }
        }
        return false;
    }

    public int compareTo(Object o) {
        UnaryRule ur = (UnaryRule)o;
        if (this.parent < ur.parent) {
            return -1;
        }
        if (this.parent > ur.parent) {
            return 1;
        }
        if (this.child < ur.child) {
            return -1;
        }
        if (this.child > ur.child) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        Numberer n = Numberer.getGlobalNumberer("states");
        return "\"" + StringUtils.escapeString(n.object(this.parent).toString(), charsToEscape, '\\') + "\" -> \"" + StringUtils.escapeString(n.object(this.child).toString(), charsToEscape, '\\') + "\" " + this.score;
    }
}

