/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.Edge;
import edu.stanford.nlp.parser.lexparser.Hook;
import edu.stanford.nlp.parser.lexparser.Scorer;
import java.util.List;

class TwinScorer
implements Scorer {
    private Scorer scorer1;
    private Scorer scorer2;

    public double oScore(Edge edge) {
        return this.scorer1.oScore(edge) + this.scorer2.oScore(edge);
    }

    public double iScore(Edge edge) {
        return this.scorer1.iScore(edge) + this.scorer2.iScore(edge);
    }

    public boolean oPossible(Hook hook) {
        return this.scorer1.oPossible(hook) && this.scorer2.oPossible(hook);
    }

    public boolean iPossible(Hook hook) {
        return this.scorer1.iPossible(hook) && this.scorer2.iPossible(hook);
    }

    public boolean parse(List words) {
        boolean b1 = this.scorer1.parse(words);
        boolean b2 = this.scorer2.parse(words);
        return b1 && b2;
    }

    public TwinScorer(Scorer scorer1, Scorer scorer2) {
        this.scorer1 = scorer1;
        this.scorer2 = scorer2;
    }
}

