/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.Train;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Numberer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;

public class Options
implements Serializable {
    public int numWords = -1;
    public int numTags = -1;
    public int numStates = -1;
    public LexOptions lexOptions = new LexOptions();
    public TreebankLangParserParams tlpParams;
    public boolean forceCNF = false;
    public boolean doPCFG = true;
    public boolean doDep = true;
    public boolean freeDependencies = false;
    public boolean directional = true;
    public boolean genStop = true;
    public boolean distance = true;
    public boolean coarseDistance = false;
    public boolean flexiTag = false;
    public boolean dcTags = true;
    public boolean nodePrune = false;
    private static final long serialVersionUID = 3L;

    public Options() {
        this(new EnglishTreebankParserParams());
    }

    public Options(TreebankLangParserParams tlpParams) {
        this.tlpParams = tlpParams;
    }

    public TreebankLanguagePack langpack() {
        return this.tlpParams.treebankLanguagePack();
    }

    public void display() {
        try {
            System.err.println("Options parameters:");
            this.writeData(new PrintWriter(System.err));
            if (Train.printStates) {
                this.dumpNumberer(Numberer.getGlobalNumberer("states"), "states", this.tlpParams.pw(System.err));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeData(Writer w) throws IOException {
        this.numWords = Numberer.getGlobalNumberer("words").total();
        this.numTags = Numberer.getGlobalNumberer("tags").total();
        this.numStates = Numberer.getGlobalNumberer("states").total();
        PrintWriter out2 = new PrintWriter(w);
        StringBuilder sb = new StringBuilder();
        sb.append("numWords " + this.numWords + "\n");
        sb.append("numTags " + this.numTags + "\n");
        sb.append("numStates " + this.numStates + "\n");
        sb.append("useUnknownWordSignatures " + this.lexOptions.useUnknownWordSignatures + "\n");
        sb.append("smoothInUnknownsThreshold " + this.lexOptions.smoothInUnknownsThreshold + "\n");
        sb.append("parserParams " + this.tlpParams.getClass().getName() + "\n");
        sb.append("smartMutation " + this.lexOptions.smartMutation + "\n");
        sb.append("forceCNF " + this.forceCNF + "\n");
        sb.append("doPCFG " + this.doPCFG + "\n");
        sb.append("doDep " + this.doDep + "\n");
        sb.append("freeDependencies " + this.freeDependencies + "\n");
        sb.append("directional " + this.directional + "\n");
        sb.append("genStop " + this.genStop + "\n");
        sb.append("distance " + this.distance + "\n");
        sb.append("coarseDistance " + this.coarseDistance + "\n");
        sb.append("flexiTag " + this.flexiTag + "\n");
        sb.append("dcTags " + this.dcTags + "\n");
        sb.append("nPrune " + this.nodePrune + "\n");
        out2.print(sb.toString());
        out2.flush();
    }

    private void dumpNumberer(Numberer num, String name, PrintWriter pw) {
        pw.println("### Sorted contents of " + name);
        ArrayList lis = new ArrayList(num.objects());
        Collections.sort(lis);
        for (Object obj : lis) {
            pw.println(obj);
        }
        pw.println("### End sorted contents of " + name);
        pw.flush();
    }

    public void readData(BufferedReader in) throws IOException {
        String line = in.readLine();
        String value = line.substring(line.indexOf(32) + 1);
        this.numWords = Integer.parseInt(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.numTags = Integer.parseInt(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.numStates = Integer.parseInt(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.lexOptions.useUnknownWordSignatures = Integer.parseInt(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.lexOptions.smoothInUnknownsThreshold = Integer.parseInt(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        try {
            this.tlpParams = (TreebankLangParserParams)Class.forName(value).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Problem instantiating parserParams: " + line);
        }
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.lexOptions.smartMutation = Boolean.parseBoolean(value);
        line = in.readLine();
        if (line.matches("^forceCNF.*")) {
            value = line.substring(line.indexOf(32) + 1);
            this.forceCNF = Boolean.parseBoolean(value);
            line = in.readLine();
        }
        value = line.substring(line.indexOf(32) + 1);
        this.doPCFG = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.doDep = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.freeDependencies = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.directional = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.genStop = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.distance = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.coarseDistance = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.flexiTag = Boolean.parseBoolean(value);
        line = in.readLine();
        value = line.substring(line.indexOf(32) + 1);
        this.dcTags = Boolean.parseBoolean(value);
        line = in.readLine();
        if (!line.matches("^nPrune.*")) {
            throw new RuntimeException("Expected nPrune, found: " + line);
        }
        value = line.substring(line.indexOf(32) + 1);
        this.nodePrune = Boolean.parseBoolean(value);
        line = in.readLine();
        if (line.length() != 0) {
            throw new RuntimeException("Expected blank line, found: " + line);
        }
    }

    public static class LexOptions
    implements Serializable {
        public int useUnknownWordSignatures = 0;
        public int smoothInUnknownsThreshold = 100;
        public boolean smartMutation = false;
        public boolean useUnicodeType = false;
        private static final long serialVersionUID = 2805351374506855631L;
    }
}

