/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.parser.lexparser.ExhaustivePCFGParser;
import edu.stanford.nlp.trees.Constituent;
import edu.stanford.nlp.trees.LabeledScoredConstituent;
import edu.stanford.nlp.trees.LabeledScoredConstituentFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.util.Numberer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NodePruner {
    private ExhaustivePCFGParser parser;
    private TreeTransformer debinarizer;

    List<Tree> prune(List<Tree> treeList, Label label, int start, int end) {
        if (treeList.size() == 1) {
            return treeList;
        }
        Tree testTree = treeList.get(0).treeFactory().newTreeNode(label, treeList);
        int goal = Numberer.getGlobalNumberer("states").number(label.value());
        Tree tempTree = this.parser.extractBestParse(goal, start, end);
        this.parser.restoreUnaries(tempTree);
        Tree pcfgTree = this.debinarizer.transformTree(tempTree);
        Set<Constituent> pcfgConstituents = pcfgTree.constituents(new LabeledScoredConstituentFactory());
        ArrayList<Tree> prunedChildren = new ArrayList<Tree>();
        int childStart = 0;
        int numCh = testTree.numChildren();
        for (int c = 0; c < numCh; ++c) {
            Tree child = testTree.getChild(c);
            boolean isExtra = true;
            int childEnd = childStart + child.yield().size();
            LabeledScoredConstituent childConstituent = new LabeledScoredConstituent(childStart, childEnd, child.label(), 0.0);
            if (pcfgConstituents.contains(childConstituent)) {
                isExtra = false;
            }
            if (childConstituent.crosses(pcfgConstituents)) {
                isExtra = false;
            }
            if (child.isLeaf() || child.isPreTerminal()) {
                isExtra = false;
            }
            if (pcfgTree.yield().size() != testTree.yield().size()) {
                isExtra = false;
            }
            if (!label.value().startsWith("NP^NP")) {
                isExtra = false;
            }
            if (isExtra) {
                System.err.println("Pruning: " + child.label() + " from " + (childStart + start) + " to " + (childEnd + start));
                System.err.println("Was: " + testTree + " vs " + pcfgTree);
                prunedChildren.addAll(child.getChildrenAsList());
            } else {
                prunedChildren.add(child);
            }
            childStart = childEnd;
        }
        return prunedChildren;
    }

    private List<Tree> helper(List<Tree> treeList, int start) {
        ArrayList<Tree> newTreeList = new ArrayList<Tree>(treeList.size());
        for (Tree tree : treeList) {
            int end = start + tree.yield().size();
            newTreeList.add(this.prune(tree, start));
            start = end;
        }
        return newTreeList;
    }

    public Tree prune(Tree tree) {
        return this.prune(tree, 0);
    }

    Tree prune(Tree tree, int start) {
        if (tree.isLeaf() || tree.isPreTerminal()) {
            return tree;
        }
        List<Tree> children = this.helper(tree.getChildrenAsList(), start);
        children = this.prune(children, tree.label(), start, start + tree.yield().size());
        return tree.treeFactory().newTreeNode(tree.label(), children);
    }

    public NodePruner(ExhaustivePCFGParser parser, TreeTransformer debinarizer) {
        this.parser = parser;
        this.debinarizer = debinarizer;
    }
}

