/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.maxent;

import edu.stanford.nlp.io.PrintFile;
import edu.stanford.nlp.maxent.Experiments;
import edu.stanford.nlp.maxent.Feature;
import edu.stanford.nlp.maxent.Features;
import edu.stanford.nlp.util.Index;

public class Problem {
    public int exSize;
    public int fSize;
    public Experiments data;
    public Features functions;

    public Problem(Experiments d, Features f) {
        this.data = d;
        this.functions = f;
        this.exSize = Experiments.size();
        this.fSize = f.size();
    }

    public Problem() {
    }

    public void add(Feature f) {
        this.functions.add(f);
        ++this.fSize;
    }

    public void removeLast() {
        this.functions.removeLast();
        --this.fSize;
    }

    public void print() {
        System.out.println(" Problem printing ");
        this.data.print();
        System.out.println(" Function printing ");
        int i = 0;
        while (i < this.fSize) {
            this.functions.get(i).print();
            ++i;
        }
    }

    public void print(String filename) {
        try {
            PrintFile pf = new PrintFile(filename);
            pf.println(" Problem printing ");
            this.data.print(pf);
            pf.println(" Function printing ");
            int i = 0;
            while (i < this.fSize) {
                this.functions.get(i).print(pf);
                ++i;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in Problem.print()");
        }
    }

    public static void main(String[] args) {
        double[] f1 = new double[]{0.0, 1.0, 1.0, 0.0, 1.0, 1.0};
        double[] f2 = new double[]{1.0, 0.0, 1.0, 1.0, 0.0, 1.0};
        Experiments gophers = new Experiments();
        int i = 0;
        while (i < 3) {
            gophers.add(new Experiments());
            ++i;
        }
        i = 0;
        while (i < 3) {
            gophers.add(new Experiments());
            ++i;
        }
        gophers.ptilde();
        Index instanceIndex = gophers.createIndex();
        Features feats = new Features();
        feats.add(new Feature(gophers, f1, instanceIndex));
        feats.add(new Feature(gophers, f2, instanceIndex));
        Problem p = new Problem(gophers, feats);
        System.out.println(p.exSize);
        System.out.println(p.functions.get(1).ftilde());
    }
}

