/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.Document;
import edu.stanford.nlp.ling.DocumentReader;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.process.Tokenizer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BasicDocument
extends ArrayList
implements Document {
    protected String title = "";
    protected String originalText;
    protected final List labels = new ArrayList();
    protected TokenizerFactory tokenizerFactory;

    public BasicDocument() {
        this(PTBTokenizer.factory());
    }

    public BasicDocument(TokenizerFactory tokenizerFactory) {
        this.setTokenizerFactory(tokenizerFactory);
    }

    public BasicDocument(Document d) {
        this((Collection)d);
    }

    public BasicDocument(Collection d) {
        this();
        this.addAll(d);
    }

    public BasicDocument init(String text, String title, boolean keepOriginalText) {
        this.setTitle(title);
        this.originalText = keepOriginalText ? text : null;
        this.parse(text == null ? "" : text);
        return this;
    }

    public BasicDocument init(String text, String title) {
        return this.init(text, title, true);
    }

    public BasicDocument init(String text, boolean keepOriginalText) {
        return this.init(text, null, keepOriginalText);
    }

    public BasicDocument init(String text) {
        return this.init(text, null, true);
    }

    public BasicDocument init() {
        return this.init((String)null, null, true);
    }

    public BasicDocument init(Reader textReader, String title, boolean keepOriginalText) throws IOException {
        return this.init(DocumentReader.readText(textReader), title, keepOriginalText);
    }

    public BasicDocument init(Reader textReader, String title) throws IOException {
        return this.init(textReader, title, true);
    }

    public BasicDocument init(Reader textReader, boolean keepOriginalText) throws IOException {
        return this.init(textReader, null, keepOriginalText);
    }

    public BasicDocument init(Reader textReader) throws IOException {
        return this.init(textReader, null, true);
    }

    public BasicDocument init(File textFile, String title, boolean keepOriginalText) throws FileNotFoundException, IOException {
        Reader in = DocumentReader.getReader(textFile);
        BasicDocument bd = this.init(in, title, keepOriginalText);
        in.close();
        return bd;
    }

    public BasicDocument init(File textFile, String title) throws FileNotFoundException, IOException {
        return this.init(textFile, title, true);
    }

    public BasicDocument init(File textFile, boolean keepOriginalText) throws FileNotFoundException, IOException {
        return this.init(textFile, textFile.getCanonicalPath(), keepOriginalText);
    }

    public BasicDocument init(File textFile) throws FileNotFoundException, IOException {
        return this.init(textFile, textFile.getCanonicalPath(), true);
    }

    public BasicDocument init(URL textURL, String title, boolean keepOriginalText) throws IOException {
        return this.init(DocumentReader.getReader(textURL), title, keepOriginalText);
    }

    public BasicDocument init(URL textURL, String title) throws FileNotFoundException, IOException {
        return this.init(textURL, title, true);
    }

    public BasicDocument init(URL textURL, boolean keepOriginalText) throws FileNotFoundException, IOException {
        return this.init(textURL, textURL.toExternalForm(), keepOriginalText);
    }

    public BasicDocument init(URL textURL) throws FileNotFoundException, IOException {
        return this.init(textURL, textURL.toExternalForm(), true);
    }

    public BasicDocument init(List words, String title) {
        this.setTitle(title);
        this.originalText = null;
        this.addAll(words);
        return this;
    }

    public BasicDocument init(List words) {
        return this.init(words, null);
    }

    protected void parse(String text) {
        Tokenizer toke = this.tokenizerFactory.getTokenizer(new StringReader(text));
        this.addAll(toke.tokenize());
    }

    public Collection asFeatures() {
        return this;
    }

    public Object label() {
        return this.labels.size() > 0 ? this.labels.get(0) : null;
    }

    public Collection labels() {
        return this.labels;
    }

    public void setLabel(Object label) {
        this.labels.clear();
        this.addLabel(label);
    }

    public void setLabels(Collection labels) {
        this.labels.clear();
        if (labels != null) {
            this.labels.addAll(labels);
        }
    }

    public void addLabel(Object label) {
        if (label != null) {
            this.labels.add(label);
        }
    }

    public String title() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title == null ? "" : title;
    }

    public TokenizerFactory tokenizerFactory() {
        return this.tokenizerFactory;
    }

    public void setTokenizerFactory(TokenizerFactory tokenizerFactory) {
        this.tokenizerFactory = tokenizerFactory;
    }

    public Document blankDocument() {
        BasicDocument bd;
        try {
            bd = (BasicDocument)this.getClass().newInstance();
        }
        catch (Exception e) {
            bd = new BasicDocument();
        }
        bd.setTitle(this.title());
        bd.setLabels(this.labels());
        bd.setTokenizerFactory(this.tokenizerFactory);
        return bd;
    }

    public String originalText() {
        return this.originalText;
    }

    public String presentableText() {
        StringBuffer sb = new StringBuffer();
        for (Object cur : this) {
            if (!(cur instanceof HasWord)) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(((HasWord)cur).word());
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            BasicDocument.printState(new BasicDocument().init("this is the text", "this is the title [String]", true));
            BasicDocument.printState(new BasicDocument().init(new StringReader("this is the text"), "this is the title [Reader]", true));
            File f = File.createTempFile("BasicDocumentTestFile", null);
            f.deleteOnExit();
            PrintWriter out2 = new PrintWriter(new FileWriter(f));
            out2.print("this is the text");
            out2.flush();
            out2.close();
            BasicDocument.printState(new BasicDocument().init(f, "this is the title [File]", true));
            BasicDocument.printState(new BasicDocument().init(new URL("http://www.stanford.edu/~jsmarr/BasicDocumentTestFile.txt"), "this is the title [URL]", true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printState(BasicDocument bd) throws Exception {
        System.err.println("BasicDocument:");
        System.err.println("\tTitle: " + bd.title());
        System.err.println("\tLabels: " + bd.labels());
        System.err.println("\tOriginalText: " + bd.originalText());
        System.err.println("\tWords: " + bd);
        System.err.println();
    }
}

