/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io;

import edu.stanford.nlp.util.Pair;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

public class NumberRangesFileFilter
implements FileFilter {
    private List ranges = new ArrayList();
    private boolean recursively;

    public NumberRangesFileFilter(String ranges, boolean recurse) {
        this.recursively = recurse;
        try {
            String[] ra = ranges.split(",");
            for (int i = 0; i < ra.length; ++i) {
                String[] one = ra[i].split("-");
                if (one.length > 2) {
                    throw new IllegalArgumentException("Too many hyphens");
                }
                int low = Integer.parseInt(one[0].trim());
                int high = one.length == 2 ? Integer.parseInt(one[1].trim()) : low;
                Pair<Integer, Integer> p = new Pair<Integer, Integer>(new Integer(low), new Integer(high));
                this.ranges.add(p);
            }
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Constructor argument not valid: " + ranges);
            iae.initCause(e);
            throw iae;
        }
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return this.recursively;
        }
        String filename = file.getName();
        int k = filename.length() - 1;
        char c = filename.charAt(k);
        while (k >= 0 && !Character.isDigit(c)) {
            if (--k < 0) continue;
            c = filename.charAt(k);
        }
        if (k < 0) {
            return false;
        }
        int j = k;
        c = filename.charAt(j);
        while (j >= 0 && Character.isDigit(c)) {
            if (--j < 0) continue;
            c = filename.charAt(j);
        }
        String theNumber = filename.substring(++j, ++k);
        int number = Integer.parseInt(theNumber);
        for (Pair p : this.ranges) {
            int low = (Integer)p.first();
            int high = (Integer)p.second();
            if (number < low || number > high) continue;
            return true;
        }
        return false;
    }
}

