/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class IOUtils {
    private IOUtils() {
    }

    public static File writeObjectToFile(Serializable o, String filename) throws IOException {
        File file = new File(filename);
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file))));
        oos.writeObject(o);
        oos.close();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeObjectToFileNoExceptions(Serializable o, String filename) {
        File file = null;
        ObjectOutputStream oos = null;
        try {
            file = new File(filename);
            oos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file))));
            oos.writeObject(o);
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception ioe) {}
            }
        }
        return file;
    }

    public static File writeObjectToTempFile(Serializable o, String filename) throws IOException {
        File file = File.createTempFile(filename, ".tmp");
        file.deleteOnExit();
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file))));
        oos.writeObject(o);
        oos.close();
        return file;
    }

    public static File writeObjectToTempFileNoExceptions(Serializable o, String filename) {
        try {
            return IOUtils.writeObjectToTempFile(o, filename);
        }
        catch (Exception e) {
            System.err.println("Error writing object to file " + filename);
            e.printStackTrace();
            return null;
        }
    }

    public static Object readObjectFromFile(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
        Object o = ois.readObject();
        ois.close();
        return o;
    }

    public static Object readObjectFromFile(String filename) throws IOException, ClassNotFoundException {
        return IOUtils.readObjectFromFile(new File(filename));
    }

    public static Object readObjectFromFileNoExceptions(File file) {
        Object o = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
            o = ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return o;
    }

    public static int lineCount(File textFile) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(textFile));
        int numLines = 0;
        while (r.readLine() != null) {
            ++numLines;
        }
        return numLines;
    }
}

