/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.IPointer;
import edu.mit.jwi.item.POS;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pointer
implements IPointer {
    public static final Pointer ALSO_SEE = new Pointer("^", "Also See");
    public static final Pointer ANTONYM = new Pointer("!", "Antonym");
    public static final Pointer ATTRIBUTE = new Pointer("=", "Attribute");
    public static final Pointer CAUSE = new Pointer(">", "Cause");
    public static final Pointer DERIVATIONALLY_RELATED = new Pointer("+", "Derivationally related form");
    public static final Pointer DERIVED_FROM_ADJ = new Pointer("\\", "Derived from adjective");
    public static final Pointer ENTAILMENT = new Pointer("*", "Entailment");
    public static final Pointer HYPERNYM = new Pointer("@", "Hypernym");
    public static final Pointer HYPERNYM_INSTANCE = new Pointer("@i", "Instance hypernym");
    public static final Pointer HYPONYM = new Pointer("~", "Hyponym");
    public static final Pointer HYPONYM_INSTANCE = new Pointer("~i", "Instance hyponym");
    public static final Pointer HOLONYM_MEMBER = new Pointer("#m", "Member holonym");
    public static final Pointer HOLONYM_SUBSTANCE = new Pointer("#s", "Substance holonym");
    public static final Pointer HOLONYM_PART = new Pointer("#p", "Part holonym");
    public static final Pointer MERONYM_MEMBER = new Pointer("%m", "Member meronym");
    public static final Pointer MERONYM_SUBSTANCE = new Pointer("%s", "Substance meronym");
    public static final Pointer MERONYM_PART = new Pointer("%p", "Part meronym");
    public static final Pointer PARTICIPLE = new Pointer("<", "Participle");
    public static final Pointer PERTAINYM = new Pointer("\\", "Pertainym (pertains to nouns)");
    public static final Pointer REGION = new Pointer(";r", "Domain of synset - REGION");
    public static final Pointer REGION_MEMBER = new Pointer("-r", "Member of this domain - REGION");
    public static final Pointer SIMILAR_TO = new Pointer("&", "Similar To");
    public static final Pointer TOPIC = new Pointer(";c", "Domain of synset - TOPIC");
    public static final Pointer TOPIC_MEMBER = new Pointer("-c", "Member of this domain - TOPIC");
    public static final Pointer USAGE = new Pointer(";u", "Domain of synset - USAGE");
    public static final Pointer USAGE_MEMBER = new Pointer("-u", "Member of this domain - USAGE");
    public static final Pointer VERB_GROUP = new Pointer("$", "Verb Group");
    private final String fSymbol;
    private final String fName;
    private static final Map<String, Pointer> pointerMap;
    private static final Set<Pointer> pointerSet;
    private static final String ambiguousSymbol = "\\";

    public Pointer(String symbol, String name) {
        this.fSymbol = symbol;
        this.fName = name;
    }

    @Override
    public String getSymbol() {
        return this.fSymbol;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    public String toString() {
        return this.fName.toLowerCase().replace(' ', '_').replace(",", "");
    }

    public static Collection<Pointer> values() {
        return pointerSet;
    }

    public static Pointer getPointerType(String symbol, POS pos) {
        if (pos == POS.ADVERB && symbol.equals(ambiguousSymbol)) {
            return DERIVED_FROM_ADJ;
        }
        Pointer pointerType = pointerMap.get(symbol);
        if (pointerType == null) {
            throw new IllegalArgumentException("No pointer type corresponding to symbol '" + symbol + "'");
        }
        return pointerType;
    }

    static {
        Field[] fields = Pointer.class.getFields();
        ArrayList<Field> instanceFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (field.getGenericType() != Pointer.class) continue;
            instanceFields.add(field);
        }
        LinkedHashSet<Pointer> hiddenSet = new LinkedHashSet<Pointer>(instanceFields.size());
        LinkedHashMap<String, Pointer> hiddenMap = new LinkedHashMap<String, Pointer>(instanceFields.size() - 1);
        for (Field field : instanceFields) {
            try {
                Pointer ptr = (Pointer)field.get(null);
                if (ptr == null) continue;
                hiddenSet.add(ptr);
                if (ptr == DERIVED_FROM_ADJ) continue;
                hiddenMap.put(ptr.getSymbol(), ptr);
            }
            catch (IllegalAccessException e) {}
        }
        pointerSet = Collections.unmodifiableSet(hiddenSet);
        pointerMap = Collections.unmodifiableMap(hiddenMap);
    }
}

