/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.IExceptionEntryID;
import edu.mit.jwi.item.POS;

public class ExceptionEntryID
implements IExceptionEntryID {
    final String fSurface;
    final POS fPOS;

    public ExceptionEntryID(String lemma, POS pos) {
        if (pos == null) {
            throw new NullPointerException();
        }
        this.fSurface = lemma.toLowerCase();
        this.fPOS = pos;
    }

    public String getSurfaceForm() {
        return this.fSurface;
    }

    public POS getPOS() {
        return this.fPOS;
    }

    public String toString() {
        return "EID-" + this.fSurface + "-" + this.fPOS.getTag();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.fSurface.hashCode();
        result = 31 * result + this.fPOS.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IExceptionEntryID)) {
            return false;
        }
        IExceptionEntryID other = (IExceptionEntryID)obj;
        if (!this.fSurface.equals(other.getSurfaceForm())) {
            return false;
        }
        return this.fPOS.equals((Object)other.getPOS());
    }
}

