/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data;

import edu.mit.jwi.data.IContentType;
import edu.mit.jwi.data.IDataSource;
import edu.mit.jwi.data.compare.ICommentDetector;
import edu.mit.jwi.item.IVersion;
import edu.mit.jwi.item.Version;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WordnetFile<T>
implements IDataSource<T> {
    private final String fName;
    private final IVersion fVersion;
    private final IContentType<T> fContentType;
    private final ICommentDetector fDetector;
    protected final File fOriginalFile;
    protected final MappedByteBuffer fMappedBuffer;
    protected final ByteBuffer fBuffer;

    public WordnetFile(File file, IContentType<T> contentType) throws IOException {
        this.fOriginalFile = file;
        this.fName = file.getName();
        this.fContentType = contentType;
        this.fDetector = this.fContentType.getLineComparator().getCommentDetector();
        RandomAccessFile raFile = new RandomAccessFile(file, "r");
        this.fMappedBuffer = raFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        this.fBuffer = this.fMappedBuffer.asReadOnlyBuffer();
        this.fVersion = Version.extractVersion(this.fContentType, this.fBuffer);
    }

    @Override
    public IVersion getVersion() {
        return this.fVersion;
    }

    public static String getLine(ByteBuffer buf) {
        StringBuilder input = new StringBuilder();
        boolean eol = false;
        int limit = buf.limit();
        block4: while (!eol && buf.position() < limit) {
            char c = (char)buf.get();
            switch (c) {
                case '\n': {
                    eol = true;
                    continue block4;
                }
                case '\r': {
                    eol = true;
                    int cur = buf.position();
                    c = (char)buf.get();
                    if (c == '\n') continue block4;
                    buf.position(cur);
                    continue block4;
                }
            }
            input.append(c);
        }
        return buf.position() == limit && input.length() == 0 ? null : input.toString();
    }

    @Override
    public IContentType<T> getContentType() {
        return this.fContentType;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public abstract Iterator<String> iterator();

    @Override
    public abstract Iterator<String> iterator(String var1);

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.fContentType.hashCode();
        result = 31 * result + this.fOriginalFile.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WordnetFile other = (WordnetFile)obj;
        if (!this.fContentType.equals(other.fContentType)) {
            return false;
        }
        return this.fOriginalFile.equals(other.fOriginalFile);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class LineIterator
    implements Iterator<String> {
        ByteBuffer fMyBuffer;
        String previous;
        String next;

        public LineIterator(ByteBuffer file) {
            this(file, null);
        }

        public LineIterator(ByteBuffer buffer, String key) {
            this.fMyBuffer = buffer.asReadOnlyBuffer();
            if (key == null) {
                this.advance();
                return;
            }
            if ((key = key.trim()).length() == 0) {
                this.advance();
            } else {
                this.findFirstLine(key);
            }
        }

        protected abstract void findFirstLine(String var1);

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        protected void advance() {
            String line;
            this.next = null;
            do {
                line = WordnetFile.getLine(this.fMyBuffer);
            } while (WordnetFile.this.fDetector != null && WordnetFile.this.fDetector.isCommentLine(line));
            this.next = line;
        }

        @Override
        public String next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.previous = this.next;
            this.advance();
            return this.previous;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

