/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.data;

import edu.mit.jwi.data.BinarySearchWordnetFile;
import edu.mit.jwi.data.ContentType;
import edu.mit.jwi.data.DataProviderClosedException;
import edu.mit.jwi.data.DataType;
import edu.mit.jwi.data.DirectAccessWordnetFile;
import edu.mit.jwi.data.IContentType;
import edu.mit.jwi.data.IDataProvider;
import edu.mit.jwi.data.IDataSource;
import edu.mit.jwi.data.IDataType;
import edu.mit.jwi.data.parse.ILineParser;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.IVersion;
import edu.mit.jwi.item.Synset;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileProvider
implements IDataProvider {
    public static final String PROTOCOL_FILE = "file";
    private URL fUrl = null;
    private IVersion fVersion = null;
    private Set<IContentType<?>> fSearchTypes = null;
    private Map<IContentType<?>, IDataSource<?>> fileMap = null;
    private Collection<IDataSource<?>> fSources = null;

    public FileProvider(URL url) {
        this(url, ContentType.values());
    }

    public FileProvider(URL url, IContentType<?> ... types) {
        this(url, Arrays.asList(types));
    }

    public FileProvider(URL url, Collection<? extends IContentType<?>> types) {
        this.setSource(url);
        this.fSearchTypes = new HashSet(types);
    }

    @Override
    public void setSource(URL url) {
        this.fUrl = url;
    }

    @Override
    public URL getSource() {
        return this.fUrl;
    }

    @Override
    public IVersion getVersion() {
        return this.fVersion;
    }

    @Override
    public void open() throws IOException {
        File directory = this.getDirectoryHandle();
        if (!directory.exists()) {
            throw new IOException("Dictionary directory does not exist: " + directory);
        }
        ArrayList<File> files = new ArrayList<File>();
        File[] filesInDir = directory.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile();
            }
        });
        if (filesInDir.length == 0) {
            throw new IOException("No files found in " + directory);
        }
        files.addAll(Arrays.asList(filesInDir));
        this.fileMap = new HashMap();
        block0: for (IContentType<?> type : this.fSearchTypes) {
            IDataType<?> fileType = type.getDataType();
            Set<String> typePatterns = fileType.getResourceNameHints();
            Set<String> posPatterns = type.getPOS() != null ? type.getPOS().getResourceNameHints() : Collections.emptySet();
            Iterator i = files.iterator();
            while (i.hasNext()) {
                File file = (File)i.next();
                String name = file.getName();
                if (!(this.containsOneOf(name, typePatterns) & this.containsOneOf(name, posPatterns))) continue;
                i.remove();
                this.fileMap.put(type, this.createDataSource(file, type));
                continue block0;
            }
        }
        this.fVersion = this.determineVersion();
    }

    protected <T> IDataSource<T> createDataSource(File file, IContentType<T> type) throws IOException {
        if (type.getDataType() == DataType.DATA) {
            DirectAccessWordnetFile<T> src = new DirectAccessWordnetFile<T>(file, type);
            Iterator itr = src.iterator();
            String firstLine = (String)itr.next();
            if (firstLine == null) {
                return src;
            }
            ILineParser<T> parser = type.getDataType().getParser();
            ISynset s = (ISynset)parser.parseLine(firstLine);
            String key = Synset.zeroFillOffset(s.getOffset());
            String soughtLine = src.getLine(key);
            if (soughtLine != null) {
                return src;
            }
            System.err.println(System.currentTimeMillis() + " - Error on direct access in " + type.getPOS().toString() + " data file: check CR/LF endings");
        }
        return new BinarySearchWordnetFile<T>(file, type);
    }

    protected IVersion determineVersion() {
        IVersion ver = null;
        for (IDataSource<?> dataSrc : this.fileMap.values()) {
            if (dataSrc.getVersion() == null) continue;
            if (ver == null) {
                ver = dataSrc.getVersion();
                continue;
            }
            if (ver.equals(dataSrc.getVersion())) continue;
            return null;
        }
        return ver;
    }

    protected void checkOpen() {
        if (!this.isOpen()) {
            throw new DataProviderClosedException();
        }
    }

    public File getDirectoryHandle() throws IOException {
        if (!this.fUrl.getProtocol().equals(PROTOCOL_FILE)) {
            throw new IOException("URL source must use 'file' protocol");
        }
        if (this.fUrl == null) {
            throw new NullPointerException("Source not set (url=null)");
        }
        try {
            return new File(URLDecoder.decode(this.fUrl.getPath(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean containsOneOf(String target, Set<String> patterns) {
        if (patterns == null || patterns.size() == 0) {
            return true;
        }
        for (String pattern : patterns) {
            if (target.indexOf(pattern) <= -1) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.fileMap = null;
    }

    @Override
    public boolean isOpen() {
        return this.fileMap != null;
    }

    @Override
    public <T> IDataSource<T> getSource(IContentType<T> type) {
        this.checkOpen();
        return this.fileMap.get(type);
    }

    protected final <T> void registerSource(IContentType<T> type, IDataSource<T> file) {
        this.checkOpen();
        this.fileMap.put(type, file);
    }

    @Override
    public Collection<IDataSource<?>> getSources() {
        this.checkOpen();
        if (this.fSources == null) {
            this.fSources = Collections.unmodifiableCollection(this.fileMap.values());
        }
        return this.fSources;
    }
}

