/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.browse;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemRequest;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.ecf.filetransfer.events.IRemoteFileSystemBrowseEvent;
import org.eclipse.ecf.filetransfer.events.IRemoteFileSystemEvent;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.Messages;

public abstract class AbstractFileSystemBrowser {
    protected IFileID fileID = null;
    protected IRemoteFileSystemListener listener = null;
    Job job = null;
    protected Exception exception = null;
    protected IRemoteFile[] remoteFiles = null;
    Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() {
        Object object = this.lock;
        synchronized (object) {
            this.job = null;
        }
    }

    protected abstract void runRequest() throws Exception;

    public AbstractFileSystemBrowser(IFileID directoryOrFileID, IRemoteFileSystemListener listener) {
        Assert.isNotNull((Object)directoryOrFileID);
        this.fileID = directoryOrFileID;
        Assert.isNotNull((Object)listener);
        this.listener = listener;
    }

    public IRemoteFileSystemRequest sendBrowseRequest() {
        this.job = new DirectoryJob();
        this.job.schedule();
        return new IRemoteFileSystemRequest(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void cancel() {
                Object object = AbstractFileSystemBrowser.this.lock;
                synchronized (object) {
                    if (AbstractFileSystemBrowser.this.job != null) {
                        AbstractFileSystemBrowser.this.job.cancel();
                    }
                }
            }

            public IFileID getFileID() {
                return AbstractFileSystemBrowser.this.fileID;
            }

            public IRemoteFileSystemListener getRemoteFileListener() {
                return AbstractFileSystemBrowser.this.listener;
            }
        };
    }

    protected IRemoteFileSystemEvent createRemoteFileEvent() {
        return new IRemoteFileSystemBrowseEvent(){

            public IFileID getFileID() {
                return AbstractFileSystemBrowser.this.fileID;
            }

            public Exception getException() {
                return AbstractFileSystemBrowser.this.exception;
            }

            public String toString() {
                StringBuffer buf = new StringBuffer("RemoteFileSystemBrowseEvent[");
                buf.append("fileID=").append(AbstractFileSystemBrowser.this.fileID).append(";");
                buf.append("files=" + Arrays.asList(AbstractFileSystemBrowser.this.remoteFiles)).append("]");
                return buf.toString();
            }

            public IRemoteFile[] getRemoteFiles() {
                return AbstractFileSystemBrowser.this.remoteFiles;
            }
        };
    }

    class DirectoryJob
    extends Job {
        public DirectoryJob() {
            super(AbstractFileSystemBrowser.this.fileID.getName());
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                try {
                    if (monitor.isCanceled()) {
                        throw new UserCancelledException(Messages.AbstractRetrieveFileTransfer_Exception_User_Cancelled);
                    }
                    AbstractFileSystemBrowser.this.runRequest();
                }
                catch (Exception e) {
                    AbstractFileSystemBrowser.this.exception = e;
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                AbstractFileSystemBrowser.this.listener.handleRemoteFileEvent(AbstractFileSystemBrowser.this.createRemoteFileEvent());
                AbstractFileSystemBrowser.this.cleanUp();
                throw throwable;
            }
            {
                Object var3_5 = null;
            }
            AbstractFileSystemBrowser.this.listener.handleRemoteFileEvent(AbstractFileSystemBrowser.this.createRemoteFileEvent());
            AbstractFileSystemBrowser.this.cleanUp();
            return Status.OK_STATUS;
        }
    }
}

