/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.director.DirectorActivator;
import org.eclipse.equinox.internal.p2.director.Messages;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.internal.p2.director.TwoTierMap;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequirementChange;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.CapabilityQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.InvalidSyntaxException;

public class Slicer {
    private static boolean DEBUG = false;
    private IQueryable possibilites;
    private LinkedList toProcess;
    private Set considered;
    private TwoTierMap slice;
    private Dictionary selectionContext;
    private MultiStatus result;

    public Slicer(IQueryable input, Dictionary context) {
        this.possibilites = input;
        this.slice = new TwoTierMap();
        this.selectionContext = context;
        this.result = new MultiStatus("org.eclipse.equinox.p2.director", 0, Messages.Planner_Problems_resolving_plan, null);
    }

    public Slicer(IInstallableUnit[] installRoots, IInstallableUnit[] gatherAvailableInstallableUnits, Dictionary selectionContext) {
        this(new QueryableArray(gatherAvailableInstallableUnits), selectionContext);
    }

    public IQueryable slice(IInstallableUnit[] ius, IProgressMonitor monitor) {
        try {
            long start = 0L;
            if (DEBUG) {
                start = System.currentTimeMillis();
                System.out.println("Start slicing: " + start);
            }
            this.validateInput(ius);
            this.considered = new HashSet<IInstallableUnit>(Arrays.asList(ius));
            this.toProcess = new LinkedList(this.considered);
            while (!this.toProcess.isEmpty()) {
                this.processIU((IInstallableUnit)this.toProcess.removeFirst());
            }
            if (DEBUG) {
                long stop = System.currentTimeMillis();
                System.out.println("Slicing complete: " + (stop - start));
            }
        }
        catch (IllegalStateException e) {
            this.result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", e.getMessage(), (Throwable)e));
        }
        if (Tracing.DEBUG && this.result.getSeverity() != 0) {
            LogHelper.log((IStatus)this.result);
        }
        if (this.result.getSeverity() == 4) {
            return null;
        }
        return new QueryableArray(this.considered.toArray(new IInstallableUnit[this.considered.size()]));
    }

    public MultiStatus getStatus() {
        return this.result;
    }

    private void validateInput(IInstallableUnit[] ius) {
        int i = 0;
        while (i < ius.length) {
            if (!this.isApplicable(ius[i])) {
                throw new IllegalStateException("The IU " + ius[i] + " can't be installed in this environment because its filter does not match.");
            }
            ++i;
        }
    }

    private boolean isApplicable(RequiredCapability req) {
        String filter = req.getFilter();
        if (filter == null) {
            return true;
        }
        try {
            return DirectorActivator.context.createFilter(filter).match(this.selectionContext);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    private boolean isApplicable(IInstallableUnit iu) {
        String enablementFilter = iu.getFilter();
        if (enablementFilter == null) {
            return true;
        }
        try {
            return DirectorActivator.context.createFilter(enablementFilter).match(this.selectionContext);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    private void processIU(IInstallableUnit iu) {
        iu = iu.unresolved();
        this.slice.put(iu.getId(), iu.getVersion(), iu);
        if (!this.isApplicable(iu)) {
            return;
        }
        RequiredCapability[] reqs = this.getRequiredCapabilities(iu);
        if (reqs.length == 0) {
            return;
        }
        int i = 0;
        while (i < reqs.length) {
            if (this.isApplicable(reqs[i]) && reqs[i].isGreedy()) {
                this.expandRequirement(iu, reqs[i]);
            }
            ++i;
        }
    }

    private RequiredCapability[] getRequiredCapabilities(IInstallableUnit iu) {
        if (!(iu instanceof IInstallableUnitPatch)) {
            return iu.getRequiredCapabilities();
        }
        IInstallableUnitPatch patchIU = (IInstallableUnitPatch)iu;
        RequirementChange[] changes = patchIU.getRequirementsChange();
        int initialRequirementCount = iu.getRequiredCapabilities().length;
        RequiredCapability[] aggregatedCapabilities = new RequiredCapability[initialRequirementCount + changes.length];
        System.arraycopy(iu.getRequiredCapabilities(), 0, aggregatedCapabilities, 0, initialRequirementCount);
        int i = 0;
        while (i < changes.length) {
            aggregatedCapabilities[initialRequirementCount++] = changes[i].newValue();
            ++i;
        }
        return aggregatedCapabilities;
    }

    private void expandRequirement(IInstallableUnit iu, RequiredCapability req) {
        Collector matches = this.possibilites.query((Query)new CapabilityQuery(req), new Collector(), null);
        int validMatches = 0;
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit match = (IInstallableUnit)iterator.next();
            if (!this.isApplicable(match)) continue;
            ++validMatches;
            if (this.slice.containsKey(match.getId(), match.getVersion())) continue;
            this.consider(match);
        }
        if (validMatches == 0) {
            if (req.isOptional()) {
                if (DEBUG) {
                    System.out.println("No IU found to satisfy optional dependency of " + iu + " on req " + req);
                }
            } else {
                this.result.add((IStatus)new Status(2, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Planner_Unsatisfied_dependency, (Object)iu, (Object)req)));
            }
        }
    }

    private void consider(IInstallableUnit match) {
        if (this.considered.add(match)) {
            this.toProcess.addLast(match);
        }
    }
}

