/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.evidence;

import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.SimplePosition;
import edu.mit.wordnet.core.rep.sense.evidence.IContextOverlap;

public class ContextOverlap
extends SimplePosition
implements IContextOverlap {
    public static final char colon = ':';
    public static final char comma = ',';
    private final long id;
    private final int wordNum;

    protected ContextOverlap(long id, int wordNum, int offset, int length) {
        super(offset, length);
        this.id = id;
        this.wordNum = wordNum;
    }

    public ContextOverlap(long id, int offset, int length) {
        this(id, -1, offset, length);
    }

    public ContextOverlap(long id, IHasPosition p) {
        this(id, p.getOffset(), p.getLength());
    }

    public ContextOverlap(long id, int wordNum) {
        this(id, wordNum, 0, 0);
    }

    public int getWordNumber() {
        return this.wordNum;
    }

    public long getContextWordID() {
        return this.id;
    }

    public static ContextOverlap reconstitute(String value) {
        int idx = value.indexOf(58);
        long id = Long.parseLong(value.substring(0, idx));
        if ((idx = (value = value.substring(idx + 1)).indexOf(44)) == -1) {
            int wordNum = Integer.parseInt(value);
            return new ContextOverlap(id, wordNum);
        }
        int offset = Integer.parseInt(value.substring(0, idx));
        int length = Integer.parseInt(value.substring(idx + 1));
        return new ContextOverlap(id, offset, length);
    }

    public static String serialize(IContextOverlap overlap) {
        StringBuilder sb = new StringBuilder();
        sb.append(Long.toString(overlap.getContextWordID()));
        sb.append(':');
        if (overlap.getWordNumber() > 0) {
            sb.append(Integer.toString(overlap.getWordNumber()));
        } else {
            sb.append(Integer.toString(overlap.getOffset()));
            sb.append(',');
            sb.append(Integer.toString(overlap.getLength()));
        }
        return sb.toString();
    }
}

