/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.disambiguation;

import edu.mit.story.core.descriptor.IDescriptor;
import edu.mit.story.core.position.PositionComparator;
import edu.mit.story.core.util.Debug;
import edu.mit.wordnet.core.rep.sense.disambiguation.AlphabeticalComparator;
import edu.mit.wordnet.core.rep.sense.disambiguation.AlphabeticalStemComparator;
import edu.mit.wordnet.core.rep.sense.disambiguation.AmbiguousComparator;
import edu.mit.wordnet.core.rep.sense.disambiguation.IDisambiguationModel;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PresentationOrder implements IDescriptor
{
    SEQUENTIAL("edu.mit.wordnet.order.seq", "Sequential", "Sequential", PositionComparator.getInstance()),
    REV_SEQUENTIAL("edu.mit.wordnet.order.reverseSeq", "Reverse Sequential", "Reverse Sequential", PositionComparator.getReverseInstance()),
    ALPHABETICAL("edu.mit.wordnet.order.alpha", "Alphabetical", "Alphabetical", AlphabeticalComparator.getInstance()),
    REV_ALPHABETICAL("edu.mit.wordnet.order.reverseAlpha", "Reverse Alphabetical", "Reverse Alphabetical", AlphabeticalComparator.getReverseInstance()),
    ALPHABETICAL_STEM("edu.mit.wordnet.order.alphaStem", "Alphabetical by Stem", "Alphabetical by Stem", AlphabeticalStemComparator.getInstance()),
    REV_ALPHABETICAL_STEM("edu.mit.wordnet.order.reverseAlphaStem", "Reverse Alphabetical by Stem", "Reverse Alphabetical by Stem", AlphabeticalStemComparator.getReverseInstance()),
    MOST_AMBIGUOUS_FIRST("edu.mit.wordnet.order.mostAmbigFirst", "Most Ambiguous First", "Most Ambiguous First", AmbiguousComparator.getReverseInstance()),
    MOST_AMBIGUOUS_Last("edu.mit.wordnet.order.mostAmbigLast", "Most Ambiguous Last", "Most Ambiguous Last", AmbiguousComparator.getInstance()),
    MOST_FREQUENT_FIRST("edu.mit.wordnet.order.mostFreqFirst", "Most Frequent First", "Most Frequent First"),
    MOST_FREQUENT_LAST("edu.mit.wordnet.order.mostFreqLast", "Most Frequent Last", "Most Frequent Last");

    private final String id;
    private final String name;
    private final String desc;
    private final Comparator<? super IDisambiguationModel> comparator;

    private PresentationOrder(String id, String name, String desc) {
        this(id, name, desc, null);
    }

    private PresentationOrder(String id, String name, String desc, Comparator<? super IDisambiguationModel> comparator) {
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.comparator = comparator;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.desc;
    }

    public void sort(List<? extends IDisambiguationModel> items) {
        if (this.comparator != null) {
            Collections.sort(items, this.comparator);
            return;
        }
        if (this == MOST_FREQUENT_FIRST) {
            this.doMostFrequentFirstSort(items);
        } else if (this == MOST_FREQUENT_LAST) {
            this.doMostFrequentLastSort(items);
        }
    }

    protected void doMostFrequentFirstSort(List<? extends IDisambiguationModel> items) {
        Debug.implement();
    }

    protected void doMostFrequentLastSort(List<? extends IDisambiguationModel> items) {
        Debug.implement();
    }
}

