/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.dict;

import edu.mit.story.core.descriptor.IDescriptor;
import edu.mit.story.core.manager.CreatableManager;
import edu.mit.wordnet.core.rep.sense.dict.DictionaryDescriptor;
import edu.mit.wordnet.core.rep.sense.dict.IDictionaryDescriptor;
import edu.mit.wordnet.core.rep.sense.dict.IDictionaryManager;
import edu.mit.wordnet.core.rep.sense.dict.IExtendedDictionary;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryManager
extends CreatableManager<IExtendedDictionary, IDictionaryDescriptor>
implements IDictionaryManager {
    IDictionaryDescriptor latestDesc;

    protected boolean doInit() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("edu.mit.wordnet.core.dictionaries");
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("dictionary")) {
                String ver = element.getAttribute("version");
                String loc = element.getAttribute("location");
                if (loc != null) {
                    this.registerDescriptor((IDescriptor)new DictionaryDescriptor(element, ver, loc));
                }
            }
            ++n2;
        }
        for (IDictionaryDescriptor dDesc : this.idMap.values()) {
            if (this.latestDesc != null && this.latestDesc.getVersion().compareTo(dDesc.getVersion()) >= 0) continue;
            this.latestDesc = dDesc;
        }
        return true;
    }

    @Override
    public IExtendedDictionary getDictionary(String id) {
        IDictionaryDescriptor desc = (IDictionaryDescriptor)this.getDescriptor(id);
        return desc == null ? null : (IExtendedDictionary)desc.create();
    }

    @Override
    public IExtendedDictionary getLatestDictionary() {
        return this.latestDesc == null ? null : (IExtendedDictionary)this.latestDesc.create();
    }
}

