/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.algorithm;

import edu.mit.jwi.item.IWord;
import edu.mit.parsing.core.util.IBaseWordInfo;
import edu.mit.parsing.core.util.IWordInfo;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.util.Debug;
import edu.mit.wordnet.core.rep.sense.ISenseAssignment;
import edu.mit.wordnet.core.rep.sense.ISynsetAnalysis;
import edu.mit.wordnet.core.rep.sense.SenseAssignment;
import edu.mit.wordnet.core.rep.sense.algorithm.FlatSenseTagger;
import edu.mit.wordnet.core.rep.sense.algorithm.IContextSenseTagger;
import edu.mit.wordnet.core.rep.sense.evidence.ContextEvidence;
import edu.mit.wordnet.core.rep.sense.evidence.ContextOverlap;
import edu.mit.wordnet.core.rep.sense.evidence.IContextOverlap;
import edu.mit.wordnet.core.rep.sense.evidence.IEvidence;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleLeskSenseTagger
extends FlatSenseTagger
implements IContextSenseTagger {
    @Override
    public List<ISenseAssignment> tag(IWordInfo word, IDescSet contextWords) {
        List<ISenseAssignment> senses = this.tag((IBaseWordInfo)word);
        if (senses == null || senses.size() <= 1 || contextWords == null) {
            return senses;
        }
        ArrayList<ISenseAssignment> result = new ArrayList<ISenseAssignment>(senses.size());
        for (ISenseAssignment sense : senses) {
            IEvidence e = this.calculateEvidence(word, sense.getSense(), contextWords);
            result.add(new SenseAssignment(sense.getSense(), e));
        }
        return result;
    }

    protected IEvidence calculateEvidence(IWordInfo target, IWord word, IDescSet contextDescs) {
        LinkedList<ContextOverlap> overlaps = new LinkedList<ContextOverlap>();
        ISynsetAnalysis analysis = this.getDictionary().getSynsetAnalysis(word.getSynset());
        for (IDesc contextDesc : contextDescs) {
            IWordInfo contextWord = (IWordInfo)contextDesc.getData();
            if (this.overlaps((IBaseWordInfo)contextWord, (IBaseWordInfo)target)) continue;
            List<IBaseWordInfo> synonyms = analysis.getSynonyms();
            int i = 0;
            while (i < synonyms.size()) {
                if (this.overlaps((IBaseWordInfo)((IWordInfo)contextDesc.getData()), synonyms.get(i))) {
                    overlaps.add(new ContextOverlap(contextDesc.getID(), i + 1));
                }
                ++i;
            }
            Debug.err((String)"Fix me");
        }
        return overlaps.isEmpty() ? null : new ContextEvidence(overlaps.toArray(new IContextOverlap[overlaps.size()]));
    }

    protected IContextOverlap calculateOverlap(IDesc contextDesc, IDesc defDesc) {
        IWordInfo defWord;
        IWordInfo contextWord = (IWordInfo)contextDesc.getData();
        return this.overlaps((IBaseWordInfo)contextWord, (IBaseWordInfo)(defWord = (IWordInfo)defDesc.getData())) ? new ContextOverlap(contextDesc.getID(), (IHasPosition)defDesc) : null;
    }

    protected boolean overlaps(IBaseWordInfo one, IBaseWordInfo two) {
        String oneBase = one.getBaseForm();
        String twoBase = two.getBaseForm();
        return oneBase.equalsIgnoreCase(twoBase);
    }
}

