/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.wordnet.core.rep.sense.algorithm;

import edu.mit.jwi.data.parse.SenseKeyParser;
import edu.mit.jwi.item.ISenseKey;
import edu.mit.jwi.item.IWord;
import edu.mit.parsing.core.rep.pos.IPosData;
import edu.mit.parsing.core.util.IBaseWordInfo;
import edu.mit.wordnet.core.rep.sense.ISenseAssignment;
import edu.mit.wordnet.core.rep.sense.SenseAssignment;
import edu.mit.wordnet.core.rep.sense.algorithm.AbstractSenseTagger;
import edu.mit.wordnet.core.rep.sense.dict.IExtendedDictionary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatProperNounTagger
extends AbstractSenseTagger {
    public static final ISenseKey KEY_Person = SenseKeyParser.getInstance().parseLine("person%1:03:00::");
    public static final ISenseKey KEY_Location = SenseKeyParser.getInstance().parseLine("location%1:03:00::");
    public static final ISenseKey KEY_Group = SenseKeyParser.getInstance().parseLine("group%1:03:00::");
    private List<ISenseAssignment> tags;

    protected boolean doInit() {
        boolean result = super.doInit();
        return result &= this.initTags();
    }

    @Override
    public List<ISenseAssignment> doTag(IBaseWordInfo word) {
        IPosData pos = word.getPosTag();
        return pos == null || !pos.getTag().isProperNoun() ? Collections.emptyList() : this.tags;
    }

    protected boolean initTags() {
        IExtendedDictionary dict = this.getDictionary();
        if (dict == null) {
            return false;
        }
        ArrayList<SenseAssignment> list = new ArrayList<SenseAssignment>(3);
        IWord word = dict.getWord(KEY_Person);
        if (word != null) {
            list.add(new SenseAssignment(word, null));
        }
        if ((word = dict.getWord(KEY_Location)) != null) {
            list.add(new SenseAssignment(word, null));
        }
        if ((word = dict.getWord(KEY_Group)) != null) {
            list.add(new SenseAssignment(word, null));
        }
        this.tags = list.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(list);
        return true;
    }

    public List<ISenseAssignment> getTags() {
        this.checkInit();
        return this.tags;
    }

    @Override
    public boolean setDictionary(IExtendedDictionary newDict) {
        boolean result = super.setDictionary(newDict);
        if (result && this.isInitialized()) {
            this.initTags();
        }
        return result;
    }
}

