/* Filename: ArticlesAreDistinctive.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Feb 2, 2010
 */
package nil.ucm.indications2.core.rep.rules;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import nil.ucm.indications2.core.rep.IIndicationStructure;
import nil.ucm.indications2.core.rep.INucleus;
import nil.ucm.indications2.core.rep.IndicationStructureRep;
import nil.ucm.indications2.core.rep.IndicationType;
import nil.ucm.indications2.core.rep.problems.NonDistinctivePronounProblem;
import edu.mit.parsing.core.rep.token.IToken;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.build.StoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.meta.IMetaDataSet;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.check.Check;
import edu.mit.story.core.meta.check.CheckMetaRep;
import edu.mit.story.core.meta.check.ICheck;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.core 1.0.0
 */
public class PronounsAreUsuallyDistinctiveRule extends AbstractBuildRule {
	
	public static final String ID = PronounsAreUsuallyDistinctiveRule.class.getCanonicalName();
	
	public static final Set<String> pronouns = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(
			"i", "me", "myself", "mine", "my",
			"we", "us", "ourselves", "ourself", "ours", "our",
			"you", "yourself", "yours", "your",
			"he", "him", "himself", "his",
			"she", "her", "herself", "hers", "her",
			"it", "itself", "its",
			"one", "oneself", "one's",
			"they", "them", "themself", "themselves", "theirs", "their"
			)));

	/**
	 * TODO: Write comment
	 *
	 * @param rep
	 * @since nil.ucm.indications2.core 1.0.0
	 */
	public PronounsAreUsuallyDistinctiveRule() {
		super(IndicationStructureRep.getInstance());
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.build.IBuildRule#build(edu.mit.story.core.model.IStoryModel)
	 */
	public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
		
		
		Set<String> pronouns = PronounsAreUsuallyDistinctiveRule.pronouns;
		
		Set<IDesc> problems = new HashSet<IDesc>();
		
		// look for indications that have a modifier or nucleus with a single token that is an article
		IIndicationStructure is;
		INucleus nucleus;
		ISegment segment;
		IToken token;
		outer:for(IDesc desc : model.getData().getDescriptions(IndicationStructureRep.getInstance())){
			is = (IIndicationStructure)desc.getData();
			
			if(!is.getModifiers().isEmpty()) continue;
			if(is.getNuclei().size() != 1) continue;

			// get single constituent marked as non-distinctive
			nucleus = is.getNuclei().get(0);
			if(nucleus.getSegments().size() > 1) continue;
			if(nucleus.getType() == IndicationType.DISTINCTIVE || nucleus.getType() == IndicationType.UNKNOWN) continue;

			// get single token of constituent
			segment = nucleus.getSegments().first();
			if(segment.getDescs().size() > 1) continue;
			token = (IToken)segment.getDescs().first().getData();
			
			// if we have a pronoun
			if(pronouns.contains(token.getSurface().toLowerCase())){
				problems.add(desc);
				continue outer;
			}
		}
		
		// remove checked descriptions
		IDesc cd;
		IMetaDataSet<ICheck> checks;
		for(Iterator<IDesc> i = problems.iterator(); i.hasNext(); ) {
			cd = i.next();
			checks = cd.getMetaData().get(CheckMetaRep.getInstance());
			if(checks == null) continue;
			if(checks.contains(new MetaDesc<ICheck>(CheckMetaRep.getInstance(), cd, new Check(PronounsAreUsuallyDistinctiveRule.ID))))
				i.remove();
		}
		
		// return problems
		IHasPositionSet<IStoryProblem> result = new HasPositionSet<IStoryProblem>();
		StoryProblem p;
		if(isCompressing()){
			if(!problems.isEmpty()){
				p = new NonDistinctivePronounProblem(problems, ID);
				p.setCheck(PronounsAreUsuallyDistinctiveRule.ID);
				result.add(p);
			}
		} else {
			for(IDesc problem : problems){
				p = new NonDistinctivePronounProblem(problem, ID);
				p.setCheck(PronounsAreUsuallyDistinctiveRule.ID);
				result.add(p);
			}
		}
		return result;
	}

}
