/* Filename: ReferenceController.java
 * Creator: M.A. Finlayson
 * Format: Java 2 v1.6.0
 * Date created: Jan 21, 2010
 */
package nil.ucm.indications2.ui.controllers;

import java.util.LinkedList;
import java.util.List;

import nil.ucm.indications2.core.rep.model.IReferenceModel;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

import edu.mit.discourse.core.rep.referent.IReference;
import edu.mit.discourse.core.rep.referent.IReferent;
import edu.mit.discourse.core.rep.referent.RefPair;
import edu.mit.discourse.core.rep.referent.ReferentRep;
import edu.mit.discourse.ui.label.ReferentLabelProvider;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.desc.IDescSet;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.position.IHasPositionSet;
import edu.mit.story.ui.controllers.HasAnnotationController;
import edu.mit.story.ui.editor.IStoryEditor;
import edu.mit.story.ui.model.AnnotationModelChild;

/** 
 * TODO: Write comment
 *
 * @author M.A. Finlayson
 * @version $Rev$, $LastChangedDate$
 * @since nil.ucm.indications2.ui 1.0.0
 */
public class ReferenceController extends HasAnnotationController implements
		IReferenceController {
	

	private final IStoryEditor editor;
	private final IReferenceModel model;
	public final ILabelProvider lp;

	
	/**
	 * TODO: Write comment
	 *
	 * @param annoID
	 * @param model
	 * @since nil.ucm.indications2.ui 1.0.0
	 */
	public ReferenceController(IReferenceModel model, String annoID, IStoryEditor editor) {
		super(annoID, AnnotationModelChild.createChildAnnotationModel(editor));
		this.editor = editor;
		if(model == null) throw new NullPointerException();
		this.model = model;
		this.lp = new ReferentLabelProvider(editor);
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.controllers.IReferenceController#getStoryEditor()
	 */
	public IStoryEditor getStoryEditor() {
		return editor;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.controllers.IReferenceController#getReferenceModel()
	 */
	public IReferenceModel getModel() {
		return model;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.controllers.IReferenceController#capture()
	 */
	public void capture() {
		
		IHasPosition selection = editor.getSelectedRange();
		if(selection == null) return;
		
		// get overlapping references
		IDescSet descs = editor.getStoryModel().getData().getDescriptions(ReferentRep.getInstance());	
		descs = (selection.getLength() == 0) ? descs.closedSet(selection) : descs.openSet(selection);
		
		IReferent referent;
		IHasPositionSet<IReference> refs;
		List<RefPair> list = new LinkedList<RefPair>();
		for(IDesc desc : descs){
			referent = (IReferent)desc.getData();
			refs = referent.getReferences();
			refs = (selection.getLength() == 0) ? refs.closedSet(selection) : refs.openSet(selection);
			for(IReference reference : refs) list.add(new RefPair(desc, reference));
		}
		if(list.isEmpty()) return;
		
		RefPair entry = null;

		if(list.size() == 1){
			entry = list.get(0);
		} else {
			// if we have multiple choices, open up a selection dialog
			ElementListSelectionDialog dialog = new ElementListSelectionDialog(editor.getEditorSite().getShell(), getLabelProvider());
			dialog.setMultipleSelection(false);
			dialog.setAllowDuplicates(true);
			dialog.setElements(list.toArray());
			dialog.setTitle("Select a Reference");
			dialog.setMessage("Select the appropriate reference");
			dialog.setBlockOnOpen(true);
			int result = dialog.open();
			if(result == Dialog.CANCEL) return;
			Object[] objects = dialog.getResult();
			if(objects.length != 1) return;
			entry = (RefPair)objects[0];
		}
		
		if(entry != null){
			model.setReference(entry.desc, entry.ref.getID());
			updateAnnotations();
		}
	}
	
	protected ILabelProvider getLabelProvider(){
		return lp;
	}

	/* 
	 * (non-Javadoc) @see nil.ucm.indications2.ui.controllers.IReferenceController#clear()
	 */
	public void clear() {
		model.clear();
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.core.util.IDisposable#dispose()
	 */
	public void dispose() {
		// no sub controllers to dispose
	}

	/* 
	 * (non-Javadoc) @see edu.mit.story.ui.controllers.HasAnnotationController#getPositions()
	 */
	@Override
	protected IHasPositionSet<? extends IHasPosition> getPositions() {
		return model.getSegments();
	}
	
}
