/* Filename: IIndicationStructureController.java
 * Creator: Raquel Hervas
 * Format: Java 2 v1.6.0
 * Date created: 30/09/2009
 */
package nil.ucm.indications2.ui.controllers;

import nil.ucm.indications2.core.rep.model.IIndicationStructureModel;
import nil.ucm.indications2.core.rep.model.IModifierModel;
import nil.ucm.indications2.core.rep.model.INucleusModel;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.ui.actions.IUpdatingAction;
import edu.mit.story.ui.controllers.IController;
import edu.mit.story.ui.editor.IStoryEditor;

/** 
 *   Interface for controllers corresponding to the indication structures. 
 *
 * @author Raquel Hervas
 * @version 1.0, (Jan. 10, 2010)
 * @since nil.ucm.indications.ui 1.0.0
 */
public interface IIndicationStructureController extends IController {
	
	/**
	 *   Returns the editor associated with this controller
	 */
	public IStoryEditor getStoryEditor();
	
	/**
	 *   Returns the indication structure model associates with this controller
	 */
	public IIndicationStructureModel getIndicationStructureModel();
		
	/** 
	 *   Returns the controller for the information about the reference
	 */
	public IReferenceController getReferenceController();

	/**
	 *   Returns the controller for the nuclei
	 */
	public INucleusController getNucleusController();

	/**
	 *   Returns the controller for the modifiers
	 */
	public IModifierController getModifierController();
	
	/**
	 *   Adds a nucleus to the corresponding model
	 */
	public void addNucleus();
	
	/**
	 *   Adds a modifier to the corresponding model
	 */
	public void addModifier();
	
	public void removeModifier(IModifierModel mod);
	
	public void removeNucleus(INucleusModel nuc);
	
	public void toggleCopularPredicate();
	
	public void commit();
	
	public void load(IDesc desc);
	
	public void clear();
	
	public IUpdatingAction getActionDelete();

	public IUpdatingAction getActionEdit();

}
