/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddItr<T>
implements Iterable<T> {
    private final List<T> elements;
    private final Iterable<? extends T> iterable;

    public AddItr(T e, Iterable<? extends T> iterable) {
        if (iterable == null) {
            throw new NullPointerException();
        }
        this.elements = Collections.singletonList(e);
        this.iterable = iterable;
    }

    public AddItr(Iterable<? extends T> c, Iterable<? extends T> iterable) {
        if (iterable == null) {
            throw new NullPointerException();
        }
        this.elements = new LinkedList<T>();
        this.iterable = iterable;
        Iterator<T> i = c.iterator();
        while (i.hasNext()) {
            this.elements.add(i.next());
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new AddIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AddIterator
    implements Iterator<T> {
        private final Iterator<T> first;
        private final Iterator<? extends T> second;
        private Iterator<?> last;

        protected AddIterator() {
            this.first = AddItr.this.elements.iterator();
            this.second = AddItr.this.iterable.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.first.hasNext() || this.second.hasNext();
        }

        @Override
        public T next() {
            if (this.first.hasNext()) {
                this.last = this.first;
                return this.first.next();
            }
            this.last = this.second;
            return this.second.next();
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.last.remove();
        }
    }
}

