/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.core.meta.timing;

import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.mappers.BlockMapper;
import edu.mit.story.core.meta.MetaRep;
import edu.mit.story.core.meta.timing.ITiming;
import edu.mit.story.core.meta.timing.Timing;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TimingMetaRep
extends MetaRep<ITiming> {
    public static final String ID = "edu.mit.story.meta.timing";
    public static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd+HH:mm:ss.SSSZ");

    public static TimingMetaRep getInstance() {
        return (TimingMetaRep)StoryPlugin.getDefault().getMetaRepManager().getMetaRep(ID);
    }

    public TimingMetaRep() {
        super(ITiming.class, true);
    }

    @Override
    public String serialize(ITiming data) {
        ArrayList<String> fields = new ArrayList<String>(3);
        fields.add(data.getStart() == null ? "" : format.format(data.getStart()));
        fields.add(data.getStop() == null ? "" : format.format(data.getStop()));
        fields.add(data.getSource());
        return BlockMapper.PIPE.serialize(fields);
    }

    @Override
    public ITiming reconstitute(String description) {
        List<String> fields = BlockMapper.PIPE.reconstitute(description);
        Date startDate = null;
        Date stopDate = null;
        if (fields.get(0).length() != 0) {
            try {
                startDate = format.parse(fields.get(0));
            }
            catch (Exception exception) {}
        }
        if (fields.get(1).length() != 0) {
            try {
                stopDate = format.parse(fields.get(1));
            }
            catch (Exception exception) {}
        }
        try {
            return new Timing(startDate, stopDate, fields.get(2));
        }
        catch (Exception exception) {
            return null;
        }
    }
}

