/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.parsing.core.rep.tag;

import edu.mit.parsing.core.ParsingPlugin;
import edu.mit.parsing.core.rep.parse.ParseRep;
import edu.mit.parsing.core.rep.tag.ITagData;
import edu.mit.parsing.core.rep.tag.TagData;
import edu.mit.parsing.core.rep.tag.tagset.ITagset;
import edu.mit.parsing.core.rep.token.TokenRep;
import edu.mit.story.core.StoryPlugin;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.ISegment;
import edu.mit.story.core.desc.SegmentMapper;
import edu.mit.story.core.desc.SegmentSet;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.IHasPosition;
import edu.mit.story.core.property.ConfigDescriptor;
import edu.mit.story.core.property.FilePropertyDescriptor;
import edu.mit.story.core.property.IConfigDescriptor;
import edu.mit.story.core.property.IConfiguration;
import edu.mit.story.core.rep.AbstractRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.core.rep.IRepSet;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TagRep
extends AbstractRep {
    public static final String ID = "edu.mit.parsing.tag";
    private static final long serialVersionUID = 1L;
    private static IRep instance = null;
    public static final String PARAM_KEY_TagsetPath = "tagsetPath";

    public static IRep getInstance() {
        if (instance == null) {
            instance = StoryPlugin.getDefault().getRepManager().getRep(ID);
        }
        return instance;
    }

    public TagRep() {
        super(ITagData.class, v11, 1);
    }

    protected void initAntecedentsInternal(IRepSet container) {
        container.add((Object)TokenRep.getInstance());
        container.add((Object)ParseRep.getInstance());
    }

    public String serialize(IData data) {
        ITagData tagData = (ITagData)data;
        StringBuilder sb = new StringBuilder();
        sb.append(tagData.getTagID());
        sb.append('|');
        sb.append(SegmentMapper.serializeStatic((Collection)((Object)tagData)));
        return sb.toString();
    }

    public TagData reconstitute(IHasPosition p, String data, IStoryModel model) {
        int idx = data.lastIndexOf(124);
        String tagID = data.substring(0, idx);
        String regionStr = data.substring(idx + 1);
        List segments = new SegmentMapper((IRep)this, model.getData()).reconstitute(regionStr);
        return new TagData(tagID, (Collection<? extends ISegment>)new SegmentSet((Collection)segments));
    }

    protected IConfigDescriptor createConfigurationDescriptor(String id, String name, String desc) {
        return new TagsetRepConfigDescriptor(id, name, desc);
    }

    public static ITagset getTagset(IStoryModel model) {
        String tagsetPath = TagRep.getTagsetPath(model);
        if (tagsetPath == null) {
            return null;
        }
        return ParsingPlugin.getDefault().getTagsetManager().createByPath(tagsetPath);
    }

    public static String getTagsetPath(IStoryModel model) {
        IConfiguration config = model.getData().getConfiguration(TagRep.getInstance());
        if (config == null) {
            return null;
        }
        String path = (String)config.get((Object)PARAM_KEY_TagsetPath);
        if (path == null) {
            return null;
        }
        if (new Path(path).isAbsolute()) {
            return path;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(model.getCorpus());
        IPath fullPath = project.getFullPath().append(path);
        return fullPath.toPortableString();
    }

    public static class TagsetRepConfigDescriptor
    extends ConfigDescriptor {
        private static final long serialVersionUID = 1L;

        public TagsetRepConfigDescriptor(String id, String name, String desc) {
            this();
            this.setID(id);
            this.setName(name);
            this.setDescription(desc);
        }

        public TagsetRepConfigDescriptor() {
            String desc = "Path to the file specifying the tagset. Paths starting with a leading slash are interpreted as relative to the workspace root and their first element must be a workspace project.  Otherwise, paths are interpreted as relative to the story corpus root.";
            FilePropertyDescriptor d = new FilePropertyDescriptor(TagRep.PARAM_KEY_TagsetPath, "Tagset File", desc, new String[]{"tagset"});
            this.put(d.getID(), d);
        }
    }
}

