/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.discourse.ui.actions;

import edu.mit.discourse.core.rep.refprops.IReferentProperty;
import edu.mit.discourse.core.rep.refprops.PropertyType;
import edu.mit.discourse.core.rep.refprops.RefPropRep;
import edu.mit.discourse.core.rep.refprops.ReferentProperty;
import edu.mit.story.core.desc.Desc;
import edu.mit.story.core.desc.IData;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.descriptor.IHasName;
import edu.mit.story.core.meta.IMetaData;
import edu.mit.story.core.meta.IMetaDesc;
import edu.mit.story.core.meta.IMetaRep;
import edu.mit.story.core.meta.MetaDesc;
import edu.mit.story.core.meta.origin.Origin;
import edu.mit.story.core.meta.origin.OriginMetaRep;
import edu.mit.story.core.meta.timing.Timing;
import edu.mit.story.core.meta.timing.TimingMetaRep;
import edu.mit.story.core.model.change.AddDescriptionsChange;
import edu.mit.story.core.model.change.CompositeModelChange;
import edu.mit.story.core.model.change.IModelChange;
import edu.mit.story.core.model.change.RemoveDescriptionsChange;
import edu.mit.story.core.rep.IHasRep;
import edu.mit.story.core.rep.IRep;
import edu.mit.story.ui.actions.SelectionUtils;
import edu.mit.story.ui.content.StoryEditorContentProvider;
import edu.mit.story.ui.editor.IStoryEditor;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.actions.ActionGroup;

public class ChangePropertyTypeActionGroup
extends ActionGroup {
    private IMenuManager typeMenu;

    public ChangePropertyTypeActionGroup(IStoryEditor editor) {
        this.createActions(editor);
    }

    public IRep getRep() {
        return RefPropRep.getInstance();
    }

    protected void createActions(final IStoryEditor editor) {
        this.typeMenu = new MenuManager("&Type");
        this.typeMenu.setRemoveAllWhenShown(true);
        this.typeMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PropertyType[] propertyTypeArray = PropertyType.values();
                int n = propertyTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyType type = propertyTypeArray[n2];
                    manager.add((IAction)new ChangeTypeAction(type, editor));
                    ++n2;
                }
            }
        });
    }

    protected static String extractName(Object obj) {
        StringBuilder sb = new StringBuilder();
        if (obj instanceof IHasName) {
            sb.append(((IHasName)obj).getName());
        } else {
            sb.append(obj.toString());
        }
        sb.insert(0, '&');
        return sb.toString();
    }

    public void fillContextMenu(IMenuManager menu) {
        Object element = SelectionUtils.extractSingle((ISelection)this.getContext().getSelection(), Object.class);
        Object obj = element;
        if (obj instanceof IDesc) {
            IDesc d = (IDesc)obj;
            if (this.getRep().isType((IHasRep)d)) {
                obj = d.getData();
            }
        }
        boolean all = obj instanceof IReferentProperty;
        StoryEditorContentProvider.Element child = null;
        if (obj instanceof StoryEditorContentProvider.Element) {
            child = (StoryEditorContentProvider.Element)obj;
            obj = child.getElement();
        }
        if (all || obj instanceof PropertyType) {
            menu.appendToGroup("additions", (IContributionItem)this.typeMenu);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ChangeEventFeatureAction<F>
    extends Action {
        private F feature;
        private IStoryEditor editor;

        public ChangeEventFeatureAction(F feature, IStoryEditor editor) {
            super(ChangePropertyTypeActionGroup.extractName(feature), 2);
            if (feature == null) {
                throw new NullPointerException();
            }
            if (editor == null) {
                throw new NullPointerException();
            }
            this.feature = feature;
            this.editor = editor;
        }

        public F getFeature() {
            return this.feature;
        }

        protected IDesc getTargetDesc() {
            Object element = SelectionUtils.extractSingle((ISelection)ChangePropertyTypeActionGroup.this.getContext().getSelection(), Object.class);
            if (element instanceof StoryEditorContentProvider.Element) {
                StoryEditorContentProvider.Element child = (StoryEditorContentProvider.Element)element;
                element = child.getParent();
            }
            if (element instanceof IDesc) {
                IDesc d = (IDesc)element;
                if (ChangePropertyTypeActionGroup.this.getRep().isType((IHasRep)d)) {
                    return d;
                }
            }
            return null;
        }

        public boolean isChecked() {
            Object element = SelectionUtils.extractSingle((ISelection)ChangePropertyTypeActionGroup.this.getContext().getSelection(), Object.class);
            if (element instanceof StoryEditorContentProvider.Element) {
                StoryEditorContentProvider.Element child = (StoryEditorContentProvider.Element)element;
                element = child.getParent();
            }
            if (element instanceof IDesc) {
                IDesc d = (IDesc)element;
                element = d.getData();
            }
            if (element instanceof IReferentProperty) {
                return this.isChecked((IReferentProperty)element);
            }
            return false;
        }

        protected abstract boolean isChecked(IReferentProperty var1);

        public void run() {
            IDesc oldDesc = this.getTargetDesc();
            if (oldDesc == null) {
                throw new IllegalStateException("no description on which to work");
            }
            IReferentProperty newData = this.create((IReferentProperty)oldDesc.getData());
            Desc newDesc = new Desc(oldDesc.getID(), oldDesc.getRep(), newData.calculatePosition(), (IData)newData, null);
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)OriginMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)Origin.USER_SPECIFIED));
            newDesc.getMetaData().addDesc((IMetaDesc)new MetaDesc((IMetaRep)TimingMetaRep.getInstance(), (IDesc)newDesc, (IMetaData)new Timing(((Object)((Object)this)).getClass().getCanonicalName(), true)));
            RemoveDescriptionsChange change = new RemoveDescriptionsChange(oldDesc);
            change = new CompositeModelChange(new IModelChange[]{change, new AddDescriptionsChange((IDesc)newDesc)});
            this.editor.getStoryModel().applyChange((Object)this, (IModelChange)change, false);
        }

        protected abstract IReferentProperty create(IReferentProperty var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangeTypeAction
    extends ChangeEventFeatureAction<PropertyType> {
        public ChangeTypeAction(PropertyType feature, IStoryEditor editor) {
            super(feature, editor);
        }

        @Override
        protected boolean isChecked(IReferentProperty e) {
            return e.getType() == this.getFeature();
        }

        @Override
        protected IReferentProperty create(IReferentProperty oldProp) {
            return new ReferentProperty((PropertyType)this.getFeature(), oldProp.getReferringExpression(), (Collection)oldProp.getExtent());
        }
    }
}

