/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.dialogs;

import edu.mit.story.ui.StoryUIMessages;
import edu.mit.story.ui.editor.IStoryEditor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class SpecifyPositionDialog
extends Dialog {
    private IStoryEditor fEditor;
    Spinner offsetInput;
    Spinner lengthInput;
    IAnnotationModelExtension fModel;
    Annotation fAnnotation = new Annotation("edu.mit.story.ui.annotation.target0", false, StoryUIMessages.ANNOTATION_PositionSpecification_text);

    public SpecifyPositionDialog(IStoryEditor editor, Shell parent) {
        super(parent);
        if (editor == null) {
            throw new NullPointerException();
        }
        this.fEditor = editor;
        this.fModel = (IAnnotationModelExtension)this.fEditor.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        this.fModel.modifyAnnotationPosition(this.fAnnotation, new Position(0, 0));
        final int max = this.fEditor.getStoryModel().getLength();
        Label offsetLabel = new Label(composite, 0);
        offsetLabel.setText("Offset:");
        this.offsetInput = new Spinner(composite, 2048);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.offsetInput.setLayoutData((Object)data);
        this.offsetInput.setSelection(0);
        this.offsetInput.setMinimum(0);
        this.offsetInput.setMaximum(max);
        this.offsetInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SpecifyPositionDialog.this.lengthInput.getSelection() > max - SpecifyPositionDialog.this.offsetInput.getSelection()) {
                    SpecifyPositionDialog.this.lengthInput.setSelection(max - SpecifyPositionDialog.this.offsetInput.getSelection());
                }
                SpecifyPositionDialog.this.fModel.modifyAnnotationPosition(SpecifyPositionDialog.this.fAnnotation, new Position(SpecifyPositionDialog.this.offsetInput.getSelection(), SpecifyPositionDialog.this.lengthInput.getSelection()));
            }
        });
        Label lengthLabel = new Label(composite, 0);
        lengthLabel.setText("Length:");
        this.lengthInput = new Spinner(composite, 2048);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.lengthInput.setLayoutData((Object)data);
        this.lengthInput.setSelection(0);
        this.lengthInput.setMinimum(0);
        this.lengthInput.setMaximum(this.fEditor.getStoryModel().getLength());
        this.lengthInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (SpecifyPositionDialog.this.offsetInput.getSelection() > max - SpecifyPositionDialog.this.lengthInput.getSelection()) {
                    SpecifyPositionDialog.this.offsetInput.setSelection(max - SpecifyPositionDialog.this.lengthInput.getSelection());
                }
                SpecifyPositionDialog.this.fModel.modifyAnnotationPosition(SpecifyPositionDialog.this.fAnnotation, new Position(SpecifyPositionDialog.this.offsetInput.getSelection(), SpecifyPositionDialog.this.lengthInput.getSelection()));
            }
        });
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Position");
    }

    protected void okPressed() {
        this.fEditor.setSelection(this.offsetInput.getSelection(), this.lengthInput.getSelection());
        super.okPressed();
    }

    public void create() {
        super.create();
    }

    public boolean close() {
        this.fModel.modifyAnnotationPosition(this.fAnnotation, null);
        return super.close();
    }
}

