/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.story.ui.actions;

import edu.mit.story.core.element.IStoryElement;
import edu.mit.story.core.element.IStoryElementSet;
import edu.mit.story.core.model.IMutableStoryModel;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.util.IUtilityClass;
import edu.mit.story.ui.actions.DescActionUtils;
import edu.mit.story.ui.actions.RepActionUtils;
import edu.mit.story.ui.clipboard.ClipboardUtils;
import org.eclipse.swt.dnd.Clipboard;

public final class StoryElementSetActionUtils
implements IUtilityClass {
    private StoryElementSetActionUtils() {
    }

    public static boolean canCut(IStoryElementSet elements, IMutableStoryModel provider) {
        return StoryElementSetActionUtils.canDelete(elements, provider) & StoryElementSetActionUtils.canCopy(elements);
    }

    public static boolean canCopy(IStoryElementSet elements) {
        if (elements == null) {
            return false;
        }
        return !elements.isEmpty();
    }

    public static boolean canPaste(IStoryElementSet elements, IMutableStoryModel provider) {
        if (elements == null | provider == null) {
            return false;
        }
        return DescActionUtils.canPaste(elements.getDescriptions(), (IStoryModel)provider) & RepActionUtils.canPaste(elements.getRepresentations(), provider);
    }

    public static boolean canDelete(IStoryElementSet elements, IMutableStoryModel provider) {
        if (elements == null | provider == null) {
            return false;
        }
        return !elements.involves(provider.getPrimary());
    }

    public static boolean doCut(Object source, IStoryElementSet elements, IMutableStoryModel provider, Clipboard clipboard) {
        if (clipboard == null) {
            return false;
        }
        if (!StoryElementSetActionUtils.canCut(elements, provider)) {
            return false;
        }
        StoryElementSetActionUtils.doCopy(source, elements, clipboard);
        return true;
    }

    public static boolean doCopy(Object source, IStoryElementSet elements, Clipboard clipboard) {
        if (clipboard == null) {
            return false;
        }
        if (!StoryElementSetActionUtils.canCopy(elements)) {
            return false;
        }
        ClipboardUtils.putStoryObject((IStoryElement)elements, clipboard);
        return true;
    }

    public static boolean doCopyData(Object source, IStoryElementSet elements, Clipboard clipboard) {
        if (clipboard == null) {
            return false;
        }
        if (!StoryElementSetActionUtils.canCopy(elements)) {
            return false;
        }
        ClipboardUtils.putStoryObjectData((IStoryElement)elements, clipboard);
        return true;
    }

    public static boolean doDelete(Object source, IStoryElementSet elements, IMutableStoryModel provider) {
        if (!StoryElementSetActionUtils.canDelete(elements, provider)) {
            return false;
        }
        return false;
    }
}

