/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.director.ApplicablePatchQuery;
import org.eclipse.equinox.internal.p2.director.DirectorActivator;
import org.eclipse.equinox.internal.p2.director.Messages;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.internal.p2.director.TwoTierMap;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequirementChange;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.CapabilityQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.InvalidSyntaxException;
import org.sat4j.specs.IProblem;

public class Projector {
    private static boolean DEBUG = Tracing.DEBUG_PLANNER_PROJECTOR;
    private IQueryable picker;
    private Map variables;
    private Map noopVariables;
    private List abstractVariables;
    private TwoTierMap slice;
    private Dictionary selectionContext;
    private int varCount = 1;
    private ArrayList constraints;
    private ArrayList dependencies;
    private ArrayList tautologies;
    private StringBuffer objective;
    private StringBuffer explanation = new StringBuffer("explain: ");
    private Collection solution;
    private File problemFile;
    private MultiStatus result;
    private int commentsCount = 0;
    private String optionalityExpression = null;
    private int countOptionalIUs = 0;
    private QueryableArray patches;
    static /* synthetic */ Class class$0;

    public Projector(IQueryable q, Dictionary context) {
        this.picker = q;
        this.variables = new HashMap();
        this.noopVariables = new HashMap();
        this.slice = new TwoTierMap();
        this.constraints = new ArrayList();
        this.tautologies = new ArrayList();
        this.dependencies = new ArrayList();
        this.selectionContext = context;
        this.abstractVariables = new ArrayList();
        this.result = new MultiStatus("org.eclipse.equinox.p2.director", 0, Messages.Planner_Problems_resolving_plan, null);
    }

    public void encode(IInstallableUnit[] ius, IProgressMonitor monitor) {
        try {
            long start = 0L;
            if (DEBUG) {
                start = System.currentTimeMillis();
                System.out.println("Start projection: " + start);
            }
            Iterator iusToEncode = this.picker.query((Query)InstallableUnitQuery.ANY, new Collector(), null).iterator();
            if (DEBUG) {
                ArrayList iusToOrder = new ArrayList();
                while (iusToEncode.hasNext()) {
                    iusToOrder.add(iusToEncode.next());
                }
                Collections.sort(iusToOrder);
                iusToEncode = iusToOrder.iterator();
            }
            while (iusToEncode.hasNext()) {
                this.processIU((IInstallableUnit)iusToEncode.next());
            }
            this.createConstraintsForSingleton();
            int i = 0;
            while (i < ius.length) {
                this.createMustHaves(ius[i]);
                ++i;
            }
            this.createOptimizationFunction(ius);
            this.persist();
            if (DEBUG) {
                long stop = System.currentTimeMillis();
                System.out.println("Projection complete: " + (stop - start));
            }
        }
        catch (IllegalStateException e) {
            this.result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", e.getMessage(), (Throwable)e));
        }
    }

    private String impliesNo(String a, String b) {
        return "-1 " + a + " -1 " + b + ">= -1 ;";
    }

    private String implies(String a, String b) {
        return "-1 " + a + " +1 " + b + ">= -1 ;";
    }

    private void createOptimizationFunction(IInstallableUnit[] ius) {
        this.objective = new StringBuffer("min:");
        Set s = this.slice.entrySet();
        long maxWeight = 2L;
        Iterator<Object> iterator = s.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            HashMap conflictingEntries = (HashMap)entry.getValue();
            if (conflictingEntries.size() == 1) continue;
            ArrayList toSort = new ArrayList(conflictingEntries.values());
            Collections.sort(toSort, Collections.reverseOrder());
            long weight = 2L;
            int count = toSort.size();
            int i = 1;
            while (i < count) {
                this.objective.append(' ').append(weight).append(' ').append(this.getVariable((IInstallableUnit)toSort.get(i)));
                weight *= 2L;
                ++i;
            }
            if (weight <= maxWeight) continue;
            maxWeight = weight;
        }
        maxWeight *= 2L;
        iterator = this.noopVariables.values().iterator();
        while (iterator.hasNext()) {
            this.objective.append(' ').append(maxWeight).append(' ').append(iterator.next().toString());
        }
        maxWeight *= 2L;
        iterator = this.abstractVariables.iterator();
        while (iterator.hasNext()) {
            this.objective.append(" -").append(maxWeight).append(" ").append((String)iterator.next());
        }
        this.objective.append(' ').append(this.getPatchesWeight(ius, maxWeight *= 2L));
        if ("min:".equals(this.objective.toString().trim())) {
            this.objective = new StringBuffer();
        } else {
            this.objective.append(" ;");
        }
    }

    protected StringBuffer getPatchesWeight(IInstallableUnit[] ius, long weight) {
        StringBuffer patchesWeight = new StringBuffer();
        if (this.patches == null) {
            return patchesWeight;
        }
        int i = 0;
        while (i < ius.length) {
            RequiredCapability[] reqs = ius[i].getRequiredCapabilities();
            int j = 0;
            while (j < reqs.length) {
                Collector matches = this.patches.query((Query)new CapabilityQuery(reqs[j]), new Collector(), null);
                Iterator iterator = matches.iterator();
                while (iterator.hasNext()) {
                    IInstallableUnitPatch match = (IInstallableUnitPatch)iterator.next();
                    patchesWeight.append('-').append(weight).append(' ').append(this.getVariable((IInstallableUnit)match)).append(' ');
                }
                ++j;
            }
            ++i;
        }
        return patchesWeight;
    }

    private void createMustHaves(IInstallableUnit iu) {
        this.tautologies.add(" +1 " + this.getVariable(iu) + " = 1;");
    }

    private void createNegation(IInstallableUnit iu) {
        this.createNegation(this.getVariable(iu));
    }

    private void createNegation(String var) {
        this.tautologies.add(" +1" + var + " = 0;");
    }

    private boolean isApplicable(RequiredCapability req) {
        String filter = req.getFilter();
        if (filter == null) {
            return true;
        }
        try {
            return DirectorActivator.context.createFilter(filter).match(this.selectionContext);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    private void persist() {
        try {
            this.problemFile = File.createTempFile("p2Encoding", ".opb");
            BufferedWriter w = new BufferedWriter(new FileWriter(this.problemFile));
            int clauseCount = this.tautologies.size() + this.dependencies.size() + this.constraints.size() - this.commentsCount;
            w.write("* #variable= " + this.varCount + " #constraint= " + clauseCount + "  ");
            w.newLine();
            w.write("*");
            w.newLine();
            this.displayMappingInComments(w);
            if (clauseCount == 0) {
                w.close();
                return;
            }
            w.write(this.objective.toString());
            w.newLine();
            w.newLine();
            w.write(this.explanation + " ;");
            w.newLine();
            w.newLine();
            Iterator iterator = this.dependencies.iterator();
            while (iterator.hasNext()) {
                w.write((String)iterator.next());
                w.newLine();
            }
            iterator = this.constraints.iterator();
            while (iterator.hasNext()) {
                w.write((String)iterator.next());
                w.newLine();
            }
            iterator = this.tautologies.iterator();
            while (iterator.hasNext()) {
                w.write((String)iterator.next());
                w.newLine();
            }
            w.close();
        }
        catch (IOException e) {
            this.result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Planner_Error_saving_opbfile, (Object)this.problemFile), (Throwable)e));
        }
    }

    private void displayMappingInComments(BufferedWriter w) throws IOException {
        Object key;
        if (!DEBUG) {
            return;
        }
        ArrayList vars = new ArrayList(this.variables.keySet());
        Collections.sort(vars);
        w.write("* IUs variables");
        w.newLine();
        w.write("* ");
        w.newLine();
        Iterator<Object> iterator = vars.iterator();
        while (iterator.hasNext()) {
            w.write("* ");
            key = iterator.next();
            w.write(key.toString());
            w.write("=>");
            w.write(this.variables.get(key).toString());
            w.newLine();
        }
        w.write("* ");
        w.newLine();
        w.write("* Abstract variables");
        w.newLine();
        w.write("* ");
        w.newLine();
        iterator = this.abstractVariables.iterator();
        w.write("* ");
        while (iterator.hasNext()) {
            w.write(iterator.next().toString());
            w.write(32);
        }
        w.newLine();
        w.write("* ");
        w.newLine();
        w.write("* NoOp variables");
        w.newLine();
        w.write("* ");
        w.newLine();
        iterator = this.noopVariables.keySet().iterator();
        while (iterator.hasNext()) {
            w.write("* ");
            key = iterator.next();
            w.write(key.toString());
            w.write("=>");
            w.write(this.noopVariables.get(key).toString());
            w.newLine();
        }
        w.write("* ");
        w.newLine();
    }

    private boolean isApplicable(IInstallableUnit iu) {
        String enablementFilter = iu.getFilter();
        if (enablementFilter == null) {
            return true;
        }
        try {
            return DirectorActivator.context.createFilter(enablementFilter).match(this.selectionContext);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    public void processIU(IInstallableUnit iu) {
        iu = iu.unresolved();
        this.slice.put(iu.getId(), iu.getVersion(), iu);
        this.explanation.append(" ").append(this.getVariable(iu));
        if (!this.isApplicable(iu)) {
            this.createNegation(iu);
            return;
        }
        Collector patches = this.getApplicablePatches(iu);
        this.expandLifeCycle(iu);
        if (patches.size() == 0) {
            RequiredCapability[] reqs = iu.getRequiredCapabilities();
            if (reqs.length == 0) {
                return;
            }
            int i = 0;
            while (i < reqs.length) {
                if (this.isApplicable(reqs[i])) {
                    this.expandRequirement(null, iu, reqs[i]);
                }
                ++i;
            }
            this.addOptionalityExpression();
        } else {
            HashMap<RequiredCapability, ArrayList<IInstallableUnitPatch>> unchangedRequirements = new HashMap<RequiredCapability, ArrayList<IInstallableUnitPatch>>(iu.getRequiredCapabilities().length);
            Iterator iterator = patches.iterator();
            while (iterator.hasNext()) {
                IInstallableUnitPatch patch = (IInstallableUnitPatch)iterator.next();
                RequiredCapability[][] reqs = this.mergeRequirements(iu, patch);
                if (reqs.length == 0) {
                    return;
                }
                int i = 0;
                while (i < reqs.length) {
                    if (reqs[i][0] == reqs[i][1]) {
                        if (this.isApplicable(reqs[i][0])) {
                            ArrayList<IInstallableUnitPatch> patchesAppliedElseWhere = (ArrayList<IInstallableUnitPatch>)unchangedRequirements.get(reqs[i][0]);
                            if (patchesAppliedElseWhere == null) {
                                patchesAppliedElseWhere = new ArrayList<IInstallableUnitPatch>();
                                unchangedRequirements.put(reqs[i][0], patchesAppliedElseWhere);
                            }
                            patchesAppliedElseWhere.add(patch);
                        }
                    } else {
                        if (this.isApplicable(reqs[i][1])) {
                            this.genericExpandRequirement(" -1 " + this.getVariable((IInstallableUnit)patch) + " -1 " + this.getVariable(iu), iu, reqs[i][1], " >= -1", " 1 " + this.getVariable((IInstallableUnit)patch) + "=0;");
                        }
                        if (this.isApplicable(reqs[i][0])) {
                            this.genericExpandRequirement(" 1 " + this.getVariable((IInstallableUnit)patch) + " -1 " + this.getVariable(iu), iu, reqs[i][0], " >= 0", this.implies(this.getVariable(iu), this.getVariable((IInstallableUnit)patch)));
                        }
                    }
                    ++i;
                }
                this.addOptionalityExpression();
            }
            iterator = unchangedRequirements.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                StringBuffer expression = new StringBuffer();
                List patchesApplied = (List)entry.getValue();
                ArrayList allPatches = new ArrayList(patches.toCollection());
                allPatches.removeAll(patchesApplied);
                Iterator iterator2 = allPatches.iterator();
                while (iterator2.hasNext()) {
                    IInstallableUnitPatch patch = (IInstallableUnitPatch)iterator2.next();
                    expression.append(" 1 " + this.getVariable((IInstallableUnit)patch));
                }
                if (allPatches.size() != 0) {
                    this.genericExpandRequirement(expression.toString(), iu, (RequiredCapability)entry.getKey(), " >= 0", " 1 " + this.getVariable(iu) + "=0;");
                    continue;
                }
                this.expandRequirement(null, iu, (RequiredCapability)entry.getKey());
            }
        }
    }

    private void expandLifeCycle(IInstallableUnit iu) {
        if (!(iu instanceof IInstallableUnitPatch)) {
            return;
        }
        IInstallableUnitPatch patch = (IInstallableUnitPatch)iu;
        if (patch.getLifeCycle() == null) {
            return;
        }
        this.expandNormalRequirement(null, iu, patch.getLifeCycle());
    }

    private void genericExpandRequirement(String var, IInstallableUnit iu, RequiredCapability req, String value, String negationExpression) {
        if (req.isOptional()) {
            this.genericOptionalRequirementExpansion(var, iu, req, value);
        } else {
            this.genericRequirementExpansion(var, iu, req, value, negationExpression);
        }
    }

    private RequiredCapability[][] mergeRequirements(IInstallableUnit iu, IInstallableUnitPatch patch) {
        if (patch == null) {
            return null;
        }
        RequirementChange[] changes = patch.getRequirementsChange();
        RequiredCapability[] originalRequirements = new RequiredCapability[iu.getRequiredCapabilities().length];
        System.arraycopy(iu.getRequiredCapabilities(), 0, originalRequirements, 0, originalRequirements.length);
        ArrayList<RequiredCapability[]> rrr = new ArrayList<RequiredCapability[]>();
        boolean found = false;
        int i = 0;
        while (i < changes.length) {
            int j = 0;
            while (j < originalRequirements.length) {
                if (originalRequirements[j] != null && changes[i].matches(originalRequirements[j])) {
                    found = true;
                    if (changes[i].newValue() != null) {
                        rrr.add(new RequiredCapability[]{originalRequirements[j], changes[i].newValue()});
                    } else {
                        RequiredCapability[] requiredCapabilityArray = new RequiredCapability[2];
                        requiredCapabilityArray[0] = originalRequirements[j];
                        rrr.add(requiredCapabilityArray);
                    }
                    originalRequirements[j] = null;
                }
                ++j;
            }
            if (!found && changes[i].applyOn() == null && changes[i].newValue() != null) {
                RequiredCapability[] requiredCapabilityArray = new RequiredCapability[2];
                requiredCapabilityArray[1] = changes[i].newValue();
                rrr.add(requiredCapabilityArray);
            }
            ++i;
        }
        i = 0;
        while (i < originalRequirements.length) {
            if (originalRequirements[i] != null) {
                rrr.add(new RequiredCapability[]{originalRequirements[i], originalRequirements[i]});
            }
            ++i;
        }
        return (RequiredCapability[][])rrr.toArray((T[])new RequiredCapability[rrr.size()][]);
    }

    private void addOptionalityExpression() {
        if (this.optionalityExpression != null && this.countOptionalIUs > 0) {
            this.dependencies.add(String.valueOf(this.optionalityExpression) + " >= 0;");
        }
        this.optionalityExpression = null;
        this.countOptionalIUs = 0;
    }

    private void expandOptionalRequirement(String iuVar, IInstallableUnit iu, RequiredCapability req) {
        if (iuVar == null) {
            iuVar = this.getVariable(iu);
        }
        String abstractVar = this.getAbstractVariable();
        String expression = " -1 " + abstractVar;
        Collector matches = this.picker.query((Query)new CapabilityQuery(req), new Collector(), null);
        if (this.optionalityExpression == null) {
            this.optionalityExpression = " -1 " + iuVar + " 1 " + this.getNoOperationVariable(iu);
        }
        StringBuffer comment = new StringBuffer();
        if (DEBUG) {
            comment.append("* ");
            comment.append(iu.toString());
            comment.append(" requires optionaly either ");
        }
        int countMatches = 0;
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit match = (IInstallableUnit)iterator.next();
            if (!this.isApplicable(match)) continue;
            ++countMatches;
            expression = String.valueOf(expression) + " 1 " + this.getVariable(match);
            if (!DEBUG) continue;
            comment.append(match.toString());
            comment.append(' ');
        }
        this.countOptionalIUs += countMatches;
        if (countMatches > 0) {
            if (DEBUG) {
                this.dependencies.add(comment.toString());
                ++this.commentsCount;
            }
            this.dependencies.add(this.impliesNo(this.getNoOperationVariable(iu), abstractVar));
            this.dependencies.add(String.valueOf(expression) + " >= 0;");
            this.optionalityExpression = String.valueOf(this.optionalityExpression) + " 1 " + abstractVar;
        }
        if (DEBUG) {
            System.out.println("No IU found to satisfy optional dependency of " + iu + " req " + req);
        }
    }

    private void genericOptionalRequirementExpansion(String iuVar, IInstallableUnit iu, RequiredCapability req, String value) {
        String abstractVar = this.getAbstractVariable();
        String expression = iuVar;
        Collector matches = this.picker.query((Query)new CapabilityQuery(req), new Collector(), null);
        if (this.optionalityExpression == null) {
            this.optionalityExpression = " -1 " + this.getVariable(iu) + " 1 " + this.getNoOperationVariable(iu);
        }
        StringBuffer comment = new StringBuffer();
        if (DEBUG) {
            comment.append("* ");
            comment.append(iu.toString());
            comment.append(" requires optionaly either ");
        }
        int countMatches = 0;
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit match = (IInstallableUnit)iterator.next();
            if (!this.isApplicable(match)) continue;
            ++countMatches;
            expression = String.valueOf(expression) + " 1 " + this.getVariable(match);
            if (!DEBUG) continue;
            comment.append(match.toString());
            comment.append(' ');
        }
        this.countOptionalIUs += countMatches;
        if (countMatches > 0) {
            if (DEBUG) {
                this.dependencies.add(comment.toString());
                ++this.commentsCount;
            }
            this.dependencies.add(this.impliesNo(this.getNoOperationVariable(iu), abstractVar));
            this.dependencies.add(String.valueOf(expression) + " " + value + ";");
            this.optionalityExpression = String.valueOf(this.optionalityExpression) + " 1 " + abstractVar;
        }
        if (DEBUG) {
            System.out.println("No IU found to satisfy optional dependency of " + iu + " req " + req);
        }
    }

    private void genericRequirementExpansion(String varIu, IInstallableUnit iu, RequiredCapability req, String value, String negationExpression) {
        String expression = varIu;
        Collector matches = this.picker.query((Query)new CapabilityQuery(req), new Collector(), null);
        StringBuffer comment = new StringBuffer();
        if (DEBUG) {
            comment.append("* ");
            comment.append(iu.toString());
            comment.append(" requires either ");
        }
        int countMatches = 0;
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit match = (IInstallableUnit)iterator.next();
            if (!this.isApplicable(match)) continue;
            ++countMatches;
            expression = String.valueOf(expression) + " +1 " + this.getVariable(match);
            if (!DEBUG) continue;
            comment.append(match.toString());
            comment.append(' ');
        }
        if (countMatches > 0) {
            if (DEBUG) {
                this.dependencies.add(comment.toString());
                ++this.commentsCount;
            }
            this.dependencies.add(String.valueOf(expression) + " " + value + ";");
        } else {
            this.result.add((IStatus)new Status(2, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Planner_Unsatisfied_dependency, (Object)iu, (Object)req)));
            this.dependencies.add(negationExpression);
        }
    }

    private void expandNormalRequirement(String varIu, IInstallableUnit iu, RequiredCapability req) {
        if (varIu == null) {
            varIu = this.getVariable(iu);
        }
        String expression = "-1 " + varIu;
        Collector matches = this.picker.query((Query)new CapabilityQuery(req), new Collector(), null);
        StringBuffer comment = new StringBuffer();
        if (DEBUG) {
            comment.append("* ");
            comment.append(iu.toString());
            comment.append(" requires either ");
        }
        int countMatches = 0;
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit match = (IInstallableUnit)iterator.next();
            if (!this.isApplicable(match)) continue;
            ++countMatches;
            expression = String.valueOf(expression) + " +1 " + this.getVariable(match);
            if (!DEBUG) continue;
            comment.append(match.toString());
            comment.append(' ');
        }
        if (countMatches > 0) {
            if (DEBUG) {
                this.dependencies.add(comment.toString());
                ++this.commentsCount;
            }
            this.dependencies.add(String.valueOf(expression) + " >= 0;");
        } else {
            this.result.add((IStatus)new Status(2, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Planner_Unsatisfied_dependency, (Object)iu, (Object)req)));
            this.createNegation(varIu);
        }
    }

    private Collector getApplicablePatches(IInstallableUnit iu) {
        if (this.patches == null) {
            Collector collector = this.picker.query(ApplicablePatchQuery.ANY, new Collector(), null);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.patches = new QueryableArray((IInstallableUnit[])collector.toArray((Class)clazz));
        }
        return this.patches.query(new ApplicablePatchQuery(iu), new Collector(), null);
    }

    private void expandRequirement(String var, IInstallableUnit iu, RequiredCapability req) {
        if (req.isOptional()) {
            this.expandOptionalRequirement(var, iu, req);
        } else {
            this.expandNormalRequirement(var, iu, req);
        }
    }

    private void createConstraintsForSingleton() {
        Set s = this.slice.entrySet();
        Iterator iterator = s.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            HashMap conflictingEntries = (HashMap)entry.getValue();
            if (conflictingEntries.size() < 2) continue;
            Collection conflictingVersions = conflictingEntries.values();
            String singletonRule = "";
            ArrayList<IInstallableUnit> nonSingleton = new ArrayList<IInstallableUnit>();
            int countSingleton = 0;
            Iterator conflictIterator = conflictingVersions.iterator();
            while (conflictIterator.hasNext()) {
                IInstallableUnit conflictElt = (IInstallableUnit)conflictIterator.next();
                if (conflictElt.isSingleton()) {
                    singletonRule = String.valueOf(singletonRule) + " -1 " + this.getVariable(conflictElt);
                    ++countSingleton;
                    continue;
                }
                nonSingleton.add(conflictElt);
            }
            if (countSingleton == 0) continue;
            Iterator iterator2 = nonSingleton.iterator();
            while (iterator2.hasNext()) {
                this.constraints.add(String.valueOf(singletonRule) + " -1 " + this.getVariable((IInstallableUnit)iterator2.next()) + " >= -1;");
            }
            singletonRule = String.valueOf(singletonRule) + " >= -1;";
            this.constraints.add(singletonRule);
        }
    }

    private String getVariable(IInstallableUnit iu) {
        String v = (String)this.variables.get(iu);
        if (v == null) {
            v = new String("x" + this.varCount++);
            this.variables.put(iu, v);
        }
        return v;
    }

    private String getAbstractVariable() {
        String newVar = new String("x" + this.varCount++);
        this.abstractVariables.add(newVar);
        return newVar;
    }

    private String getNoOperationVariable(IInstallableUnit iu) {
        String v = (String)this.noopVariables.get(iu);
        if (v == null) {
            v = new String("x" + this.varCount++);
            this.noopVariables.put(iu, v);
        }
        return v;
    }

    /*
     * Exception decompiling
     */
    public IStatus invokeSolver(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void backToIU(IProblem problem) {
        this.solution = new ArrayList();
        Iterator allIUs = this.variables.entrySet().iterator();
        while (allIUs.hasNext()) {
            Map.Entry entry = allIUs.next();
            int match = Integer.parseInt(((String)entry.getValue()).substring(1));
            if (!problem.model(match)) continue;
            this.solution.add(((IInstallableUnit)entry.getKey()).unresolved());
        }
    }

    private void printSolution(Collection state) {
        ArrayList l = new ArrayList(state);
        Collections.sort(l);
        System.out.println("Numbers of IUs selected:" + l.size());
        Iterator iterator = l.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    public Collection extractSolution() {
        if (DEBUG) {
            this.printSolution(this.solution);
        }
        return this.solution;
    }
}

