/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.semantics.core.rep.timelink.rules;

import edu.mit.semantics.core.rep.timelink.ITimeLink;
import edu.mit.semantics.core.rep.timelink.LinkTypeTemporal;
import edu.mit.semantics.core.rep.timelink.TimeLinkRep;
import edu.mit.semantics.core.rep.timelink.problems.IncorrectIdentityProblem;
import edu.mit.story.core.build.AbstractBuildRule;
import edu.mit.story.core.build.IStoryProblem;
import edu.mit.story.core.desc.IDesc;
import edu.mit.story.core.model.IStoryModel;
import edu.mit.story.core.position.HasPositionSet;
import edu.mit.story.core.position.IHasPositionSet;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdenticalTargetsRule
extends AbstractBuildRule {
    public static final String ID = IdenticalTargetsRule.class.getCanonicalName();

    public IdenticalTargetsRule() {
        super(TimeLinkRep.getInstance());
    }

    public IHasPositionSet<IStoryProblem> build(IStoryModel model) {
        HashSet<IDesc> problems = new HashSet<IDesc>();
        for (IDesc linkDesc : model.getData().getDescriptions(TimeLinkRep.getInstance())) {
            ITimeLink link = (ITimeLink)linkDesc.getData();
            if (link.getRelationType() != LinkTypeTemporal.IDENTITY || link.getRelated().getRep() == link.getSource().getRep()) continue;
            problems.add(linkDesc);
        }
        if (problems.isEmpty()) {
            return null;
        }
        HasPositionSet result = new HasPositionSet();
        for (IDesc desc : problems) {
            result.add((Object)new IncorrectIdentityProblem(desc, this.getID()));
        }
        return result;
    }
}

